/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordChanges;
import org.neo4j.kernel.impl.transaction.state.RecordState;
import org.neo4j.kernel.impl.util.statistics.IntCounter;

public class TransactionRecordState
implements RecordState {
    private final IntegrityValidator integrityValidator;
    private final NeoStoreTransactionContext context;
    private final NodeStore nodeStore;
    private final MetaDataStore metaDataStore;
    private final SchemaStore schemaStore;
    private RecordChanges<Long, NeoStoreRecord, Void> neoStoreRecord;
    private long lastCommittedTxWhenTransactionStarted;
    private boolean prepared;
    private static final CommandSorter COMMAND_SORTER = new CommandSorter();

    public TransactionRecordState(NeoStores neoStores, IntegrityValidator integrityValidator, NeoStoreTransactionContext context) {
        this.nodeStore = neoStores.getNodeStore();
        this.metaDataStore = neoStores.getMetaDataStore();
        this.schemaStore = neoStores.getSchemaStore();
        this.integrityValidator = integrityValidator;
        this.context = context;
    }

    public void initialize(long lastCommittedTxWhenTransactionStarted) {
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.prepared = false;
    }

    public void clear() {
        this.neoStoreRecord = null;
        this.context.clear();
    }

    @Override
    public boolean hasChanges() {
        return this.context.hasChanges() || this.neoStoreRecord != null && this.neoStoreRecord.changeSize() > 0;
    }

    @Override
    public void extractCommands(Collection<Command> commands) throws TransactionFailureException {
        Command command;
        Command.TokenCommand command2;
        assert (!this.prepared) : "Transaction has already been prepared";
        this.integrityValidator.validateTransactionStartKnowledge(this.lastCommittedTxWhenTransactionStarted);
        int noOfCommands = this.context.getNodeRecords().changeSize() + this.context.getRelRecords().changeSize() + this.context.getPropertyRecords().changeSize() + this.context.getSchemaRuleChanges().changeSize() + this.context.getPropertyKeyTokenRecords().changeSize() + this.context.getLabelTokenRecords().changeSize() + this.context.getRelationshipTypeTokenRecords().changeSize() + this.context.getRelGroupRecords().changeSize() + (this.neoStoreRecord != null ? this.neoStoreRecord.changeSize() : 0);
        for (RecordAccess.RecordProxy<Integer, LabelTokenRecord, Void> recordProxy : this.context.getLabelTokenRecords().changes()) {
            Command.LabelTokenCommand command3 = new Command.LabelTokenCommand();
            command3.init((TokenRecord)recordProxy.forReadingLinkage());
            commands.add(command3);
        }
        for (RecordAccess.RecordProxy<Integer, TokenRecord, Void> recordProxy : this.context.getRelationshipTypeTokenRecords().changes()) {
            command2 = new Command.RelationshipTypeTokenCommand();
            command2.init(recordProxy.forReadingLinkage());
            commands.add(command2);
        }
        for (RecordAccess.RecordProxy<Integer, TokenRecord, Void> recordProxy : this.context.getPropertyKeyTokenRecords().changes()) {
            command2 = new Command.PropertyKeyTokenCommand();
            command2.init(recordProxy.forReadingLinkage());
            commands.add(command2);
        }
        ArrayList<Command.NodeCommand> nodeCommands = new ArrayList<Command.NodeCommand>(this.context.getNodeRecords().changeSize());
        for (RecordAccess.RecordProxy<Long, NodeRecord, Void> change : this.context.getNodeRecords().changes()) {
            NodeRecord nodeRecord = change.forReadingLinkage();
            this.integrityValidator.validateNodeRecord(nodeRecord);
            Command.NodeCommand command22 = new Command.NodeCommand();
            command22.init(change.getBefore(), nodeRecord);
            nodeCommands.add(command22);
        }
        Collections.sort(nodeCommands, COMMAND_SORTER);
        ArrayList<Command.RelationshipCommand> arrayList = new ArrayList<Command.RelationshipCommand>(this.context.getRelRecords().changeSize());
        for (RecordAccess.RecordProxy<Long, RelationshipRecord, Void> recordProxy : this.context.getRelRecords().changes()) {
            Command.RelationshipCommand command3 = new Command.RelationshipCommand();
            command3.init(recordProxy.forReadingLinkage());
            arrayList.add(command3);
        }
        Collections.sort(arrayList, COMMAND_SORTER);
        ArrayList<Command.PropertyCommand> propCommands = new ArrayList<Command.PropertyCommand>(this.context.getPropertyRecords().changeSize());
        for (RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> change : this.context.getPropertyRecords().changes()) {
            Command.PropertyCommand propertyCommand = new Command.PropertyCommand();
            propertyCommand.init(change.getBefore(), change.forReadingLinkage());
            propCommands.add(propertyCommand);
        }
        Collections.sort(propCommands, COMMAND_SORTER);
        ArrayList<Command.RelationshipGroupCommand> arrayList2 = new ArrayList<Command.RelationshipGroupCommand>(this.context.getRelGroupRecords().changeSize());
        for (RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> recordProxy : this.context.getRelGroupRecords().changes()) {
            command = new Command.RelationshipGroupCommand();
            ((Command.RelationshipGroupCommand)command).init(recordProxy.forReadingData());
            arrayList2.add((Command.RelationshipGroupCommand)command);
        }
        Collections.sort(arrayList2, COMMAND_SORTER);
        this.addFiltered(commands, Command.Mode.CREATE, propCommands, arrayList, arrayList2, nodeCommands);
        this.addFiltered(commands, Command.Mode.UPDATE, propCommands, arrayList, arrayList2, nodeCommands);
        this.addFiltered(commands, Command.Mode.DELETE, propCommands, arrayList, arrayList2, nodeCommands);
        if (this.neoStoreRecord != null) {
            for (RecordAccess.RecordProxy<Long, Object, Object> recordProxy : this.neoStoreRecord.changes()) {
                command = new Command.NeoStoreCommand();
                ((Command.NeoStoreCommand)command).init((NeoStoreRecord)recordProxy.forReadingData());
                commands.add(command);
            }
        }
        for (RecordAccess.RecordProxy<Long, Object, Object> recordProxy : this.context.getSchemaRuleChanges().changes()) {
            this.integrityValidator.validateSchemaRule((SchemaRule)recordProxy.getAdditionalData());
            command = new Command.SchemaRuleCommand();
            ((Command.SchemaRuleCommand)command).init((Collection)recordProxy.getBefore(), (Collection)recordProxy.forChangingData(), (SchemaRule)recordProxy.getAdditionalData());
            commands.add(command);
        }
        assert (commands.size() == noOfCommands) : "Expected " + noOfCommands + " final commands, got " + commands.size() + " instead";
        this.prepared = true;
    }

    public void relCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.context.relationshipCreate(id, typeId, startNodeId, endNodeId);
    }

    public void relDelete(long relId) {
        this.context.relationshipDelete(relId);
    }

    @SafeVarargs
    private final void addFiltered(Collection<Command> target, Command.Mode mode, Collection<? extends Command> ... commands) {
        for (Collection<? extends Command> c : commands) {
            for (Command command : c) {
                if (command.getMode() != mode) continue;
                target.add(command);
            }
        }
    }

    public void nodeDelete(long nodeId) {
        NodeRecord nodeRecord = this.context.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        nodeRecord.setLabelField(Record.NO_LABELS_FIELD.intValue(), this.markNotInUse(nodeRecord.getDynamicLabelRecords()));
        this.getAndDeletePropertyChain(nodeRecord);
    }

    private Collection<DynamicRecord> markNotInUse(Collection<DynamicRecord> dynamicLabelRecords) {
        for (DynamicRecord record : dynamicLabelRecords) {
            record.setInUse(false);
        }
        return dynamicLabelRecords;
    }

    private void getAndDeletePropertyChain(NodeRecord nodeRecord) {
        this.context.getAndDeletePropertyChain(nodeRecord);
    }

    public void relRemoveProperty(long relId, int propertyKey) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Object> rel = this.context.getRelRecords().getOrLoad(relId, null);
        this.context.removeProperty(rel, propertyKey);
    }

    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        RecordAccess.RecordProxy<Long, NodeRecord, Object> node = this.context.getNodeRecords().getOrLoad(nodeId, null);
        this.context.removeProperty(node, propertyKey);
    }

    public DefinedProperty relChangeProperty(long relId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Object> rel = this.context.getRelRecords().getOrLoad(relId, null);
        this.context.primitiveChangeProperty(rel, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty nodeChangeProperty(long nodeId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, NodeRecord, Object> node = this.context.getNodeRecords().getOrLoad(nodeId, null);
        this.context.primitiveChangeProperty(node, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty relAddProperty(long relId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Object> rel = this.context.getRelRecords().getOrLoad(relId, null);
        this.context.primitiveAddProperty(rel, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty nodeAddProperty(long nodeId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, NodeRecord, Object> node = this.context.getNodeRecords().getOrLoad(nodeId, null);
        this.context.primitiveAddProperty(node, propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = this.context.getNodeRecords().create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
    }

    public void createPropertyKeyToken(String key, int id) {
        this.context.createPropertyKeyToken(key, id);
    }

    public void createLabelToken(String name, int id) {
        this.context.createLabelToken(name, id);
    }

    public void createRelationshipTypeToken(String name, int id) {
        this.context.createRelationshipTypeToken(name, id);
    }

    private RecordAccess.RecordProxy<Long, NeoStoreRecord, Void> getOrLoadNeoStoreRecord() {
        if (this.neoStoreRecord == null) {
            this.neoStoreRecord = new RecordChanges<Long, NeoStoreRecord, Void>(new RecordAccess.Loader<Long, NeoStoreRecord, Void>(){

                @Override
                public NeoStoreRecord newUnused(Long key, Void additionalData) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NeoStoreRecord load(Long key, Void additionalData) {
                    return TransactionRecordState.this.metaDataStore.asRecord();
                }

                @Override
                public void ensureHeavy(NeoStoreRecord record) {
                }

                @Override
                public NeoStoreRecord clone(NeoStoreRecord neoStoreRecord) {
                    throw new UnsupportedOperationException("Clone on NeoStoreRecord");
                }
            }, false, new IntCounter());
        }
        return this.neoStoreRecord.getOrLoad(0L, null);
    }

    public DefinedProperty graphAddProperty(int propertyKey, Object value) {
        this.context.primitiveAddProperty(this.getOrLoadNeoStoreRecord(), propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public DefinedProperty graphChangeProperty(int propertyKey, Object value) {
        this.context.primitiveChangeProperty(this.getOrLoadNeoStoreRecord(), propertyKey, value);
        return Property.property(propertyKey, value);
    }

    public void graphRemoveProperty(int propertyKey) {
        RecordAccess.RecordProxy<Long, NeoStoreRecord, Void> recordChange = this.getOrLoadNeoStoreRecord();
        this.context.removeProperty(recordChange, propertyKey);
    }

    public void createSchemaRule(SchemaRule schemaRule) {
        for (DynamicRecord change : this.context.getSchemaRuleChanges().create(schemaRule.getId(), schemaRule).forChangingData()) {
            change.setInUse(true);
            change.setCreated();
        }
    }

    public void dropSchemaRule(SchemaRule rule) {
        RecordAccess.RecordProxy<Long, Collection<DynamicRecord>, SchemaRule> change = this.context.getSchemaRuleChanges().getOrLoad(rule.getId(), rule);
        Collection<DynamicRecord> records = change.forChangingData();
        for (DynamicRecord record : records) {
            record.setInUse(false);
        }
    }

    public void addLabelToNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = this.context.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).add(labelId, this.nodeStore, this.nodeStore.getDynamicLabelStore());
    }

    public void removeLabelFromNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = this.context.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).remove(labelId, this.nodeStore);
    }

    public void setConstraintIndexOwner(IndexRule indexRule, long constraintId) {
        RecordAccess.RecordProxy<Long, Collection<DynamicRecord>, SchemaRule> change = this.context.getSchemaRuleChanges().getOrLoad(indexRule.getId(), indexRule);
        Collection<DynamicRecord> records = change.forChangingData();
        indexRule = indexRule.withOwningConstraint(constraintId);
        records.clear();
        records.addAll(this.schemaStore.allocateFrom(indexRule));
    }

    public static interface PropertyReceiver {
        public void receive(DefinedProperty var1, long var2);
    }

    private static class CommandSorter
    implements Comparator<Command> {
        private CommandSorter() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id2;
            long id1 = o1.getKey();
            long diff = id1 - (id2 = o2.getKey());
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CommandSorter;
        }

        public int hashCode() {
            return 3217;
        }
    }
}

