/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.IndexCommandDetector;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvents;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class BatchingTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final IdOrderingQueue legacyIndexTransactionOrdering;
    private final AtomicReference<ThreadLink> threadLinkHead = new AtomicReference<ThreadLink>(ThreadLink.END);
    private final TransactionMetadataCache transactionMetadataCache;
    private final LogFile logFile;
    private final LogRotation logRotation;
    private final TransactionIdStore transactionIdStore;
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private final KernelHealth kernelHealth;
    private final Lock forceLock = new ReentrantLock();
    private WritableLogChannel writer;
    private TransactionLogWriter transactionLogWriter;
    private IndexCommandDetector indexCommandDetector;

    public BatchingTransactionAppender(LogFile logFile, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, IdOrderingQueue legacyIndexTransactionOrdering, KernelHealth kernelHealth) {
        this.logFile = logFile;
        this.logRotation = logRotation;
        this.transactionIdStore = transactionIdStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.kernelHealth = kernelHealth;
        this.transactionMetadataCache = transactionMetadataCache;
    }

    @Override
    public void start() throws Throwable {
        this.writer = this.logFile.getWriter();
        this.indexCommandDetector = new IndexCommandDetector(new CommandWriter(this.writer));
        this.transactionLogWriter = new TransactionLogWriter(new LogEntryWriter(this.writer, this.indexCommandDetector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Commitment append(TransactionRepresentation transaction, LogAppendEvent logAppendEvent) throws IOException {
        long transactionId = -1L;
        int phase = 0;
        boolean logRotated = this.logRotation.rotateLogIfNeeded(logAppendEvent);
        logAppendEvent.setLogRotated(logRotated);
        try {
            TransactionCommitment commitment;
            Object object = this.logFile;
            synchronized (object) {
                try (SerializeTransactionEvent serialiseEvent = logAppendEvent.beginSerializeTransaction();){
                    transactionId = this.transactionIdStore.nextCommittingTransactionId();
                    phase = 1;
                    commitment = this.appendToLog(transaction, transactionId);
                }
            }
            this.forceAfterAppend(logAppendEvent);
            commitment.publishAsCommitted();
            this.orderLegacyIndexChanges(commitment);
            phase = 2;
            object = commitment;
            return object;
        }
        finally {
            if (phase == 1) {
                this.transactionIdStore.transactionClosed(transactionId, 0L, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Commitment append(TransactionRepresentation transaction, long expectedTransactionId) throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            long transactionId = this.transactionIdStore.nextCommittingTransactionId();
            if (transactionId != expectedTransactionId) {
                throw new ThisShouldNotHappenError("Zhen Li and Mattias Persson", "Received " + transaction + " with txId:" + expectedTransactionId + " to be applied, but appending it ended up generating an unexpected txId:" + transactionId);
            }
            return this.appendToLog(transaction, transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPoint(LogPosition logPosition, LogCheckPointEvent logCheckPointEvent) throws IOException {
        try {
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                this.transactionLogWriter.checkPoint(logPosition);
            }
        }
        catch (Throwable cause) {
            this.kernelHealth.panic(cause);
            throw cause;
        }
        this.forceAfterAppend(logCheckPointEvent);
    }

    private TransactionCommitment appendToLog(TransactionRepresentation transaction, long transactionId) throws IOException {
        this.indexCommandDetector.reset();
        try {
            LogPosition logPositionBeforeCommit = this.writer.getCurrentPosition(this.positionMarker).newPosition();
            this.transactionLogWriter.append(transaction, transactionId);
            LogPosition logPositionAfterCommit = this.writer.getCurrentPosition(this.positionMarker).newPosition();
            long transactionChecksum = LogEntryStart.checksum(transaction.additionalHeader(), transaction.getMasterId(), transaction.getAuthorId());
            this.transactionMetadataCache.cacheTransactionMetadata(transactionId, logPositionBeforeCommit, transaction.getMasterId(), transaction.getAuthorId(), transactionChecksum);
            boolean hasLegacyIndexChanges = this.indexCommandDetector.hasWrittenAnyLegacyIndexCommand();
            if (hasLegacyIndexChanges) {
                this.legacyIndexTransactionOrdering.offer(transactionId);
            }
            return new TransactionCommitment(hasLegacyIndexChanges, transactionId, transactionChecksum, logPositionAfterCommit, this.transactionIdStore);
        }
        catch (Throwable panic) {
            this.kernelHealth.panic(panic);
            throw panic;
        }
    }

    private void orderLegacyIndexChanges(TransactionCommitment commit) throws IOException {
        if (commit.hasLegacyIndexChanges) {
            try {
                this.legacyIndexTransactionOrdering.waitFor(commit.transactionId);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while waiting for applying legacy index updates", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceAfterAppend(LogForceEvents logForceEvents) throws IOException {
        ThreadLink threadLink = new ThreadLink(Thread.currentThread());
        threadLink.next = this.threadLinkHead.getAndSet(threadLink);
        try (LogForceWaitEvent logForceWaitEvent = logForceEvents.beginLogForceWait();){
            do {
                if (this.forceLock.tryLock()) {
                    try {
                        this.forceLog(logForceEvents);
                    }
                    finally {
                        this.forceLock.unlock();
                        ThreadLink nextWaiter = this.threadLinkHead.get();
                        nextWaiter.unpark();
                    }
                } else {
                    this.waitForLogForce();
                }
            } while (!threadLink.done);
        }
    }

    private void forceLog(LogForceEvents logForceEvents) throws IOException {
        ThreadLink links = this.threadLinkHead.getAndSet(ThreadLink.END);
        try (LogForceEvent logForceEvent = logForceEvents.beginLogForce();){
            this.force();
        }
        catch (Throwable panic) {
            this.kernelHealth.panic(panic);
            throw panic;
        }
        finally {
            this.unparkAll(links);
        }
    }

    private void unparkAll(ThreadLink links) {
        ThreadLink tmp;
        do {
            links.done = true;
            links.unpark();
            while ((tmp = links.next) == null) {
            }
        } while ((links = tmp) != ThreadLink.END);
    }

    private void waitForLogForce() {
        long parkTime = TimeUnit.MILLISECONDS.toNanos(100L);
        LockSupport.parkNanos(this, parkTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() throws IOException {
        Flushable flushable;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            flushable = this.writer.emptyBufferIntoChannelAndClearIt();
        }
        try {
            flushable.flush();
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private static class TransactionCommitment
    implements Commitment {
        private final boolean hasLegacyIndexChanges;
        private final long transactionId;
        private final long transactionChecksum;
        private final LogPosition logPosition;
        private final TransactionIdStore transactionIdStore;
        private boolean markedAsCommitted;

        TransactionCommitment(boolean hasLegacyIndexChanges, long transactionId, long transactionChecksum, LogPosition logPosition, TransactionIdStore transactionIdStore) {
            this.hasLegacyIndexChanges = hasLegacyIndexChanges;
            this.transactionId = transactionId;
            this.transactionChecksum = transactionChecksum;
            this.logPosition = logPosition;
            this.transactionIdStore = transactionIdStore;
        }

        @Override
        public void publishAsCommitted() {
            this.markedAsCommitted = true;
            this.transactionIdStore.transactionCommitted(this.transactionId, this.transactionChecksum);
        }

        @Override
        public void publishAsApplied() {
            this.transactionIdStore.transactionClosed(this.transactionId, this.logPosition.getLogVersion(), this.logPosition.getByteOffset());
        }

        @Override
        public long transactionId() {
            return this.transactionId;
        }

        @Override
        public boolean markedAsCommitted() {
            return this.markedAsCommitted;
        }
    }

    private static class ThreadLink {
        final Thread thread;
        volatile ThreadLink next;
        volatile boolean done;
        static final ThreadLink END;

        public ThreadLink(Thread thread) {
            this.thread = thread;
        }

        public void unpark() {
            LockSupport.unpark(this.thread);
        }

        static {
            ThreadLink.END.next = END = new ThreadLink(null);
        }
    }
}

