/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;

public class RecoveryRequiredChecker {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;

    public RecoveryRequiredChecker(FileSystemAbstraction fs, PageCache pageCache) {
        this.fs = fs;
        this.pageCache = pageCache;
    }

    public boolean isRecoveryRequiredAt(File dataDir) throws IOException {
        boolean noStoreFound;
        File neoStore = new File(dataDir, "neostore");
        boolean bl = noStoreFound = !NeoStores.isStorePresent(this.pageCache, dataDir);
        if (noStoreFound) {
            return false;
        }
        long logVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LOG_VERSION);
        PhysicalLogFiles logFiles = new PhysicalLogFiles(dataDir, this.fs);
        VersionAwareLogEntryReader<ReadableLogChannel> reader = new VersionAwareLogEntryReader<ReadableLogChannel>(LogEntryVersion.CURRENT.byteCode());
        LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, this.fs, reader);
        return new PositionToRecoverFrom(finder).apply(logVersion) != LogPosition.UNSPECIFIED;
    }
}

