/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.kernel.impl.locking.AbstractLockService;

public final class ReentrantLockService
extends AbstractLockService<OwnerQueueElement<Thread>> {
    private final ConcurrentMap<AbstractLockService.LockedEntity, OwnerQueueElement<Thread>> locks = new ConcurrentHashMap<AbstractLockService.LockedEntity, OwnerQueueElement<Thread>>();
    private final long maxParkNanos;

    int lockCount() {
        return this.locks.size();
    }

    public ReentrantLockService() {
        this(1L, TimeUnit.MILLISECONDS);
    }

    public ReentrantLockService(long maxParkTime, TimeUnit unit) {
        this.maxParkNanos = unit.toNanos(maxParkTime);
    }

    @Override
    protected OwnerQueueElement<Thread> acquire(AbstractLockService.LockedEntity key) {
        OwnerQueueElement<Thread> suggestion = new OwnerQueueElement<Thread>(Thread.currentThread());
        OwnerQueueElement<Thread> owner;
        while ((owner = this.locks.putIfAbsent(key, suggestion)) != null) {
            Thread other = (Thread)owner.owner;
            if (other == Thread.currentThread()) {
                ++owner.count;
                return owner;
            }
            if (((OwnerQueueElement)suggestion).head == suggestion && !owner.enqueue(suggestion)) continue;
            LockSupport.parkNanos(key, this.maxParkNanos);
        }
        return suggestion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void release(AbstractLockService.LockedEntity key, OwnerQueueElement<Thread> ownerQueueElement) {
        if (0 == --ownerQueueElement.count) {
            Thread nextThread;
            OwnerQueueElement<Thread> ownerQueueElement2 = ownerQueueElement;
            synchronized (ownerQueueElement2) {
                nextThread = ownerQueueElement.dequeue();
                if (nextThread == Thread.currentThread()) {
                    this.locks.remove(key, ownerQueueElement);
                    nextThread = null;
                }
            }
            LockSupport.unpark(nextThread);
        }
    }

    static final class OwnerQueueElement<OWNER> {
        volatile OWNER owner;
        int count = 1;
        private OwnerQueueElement<OWNER> head = this;
        private OwnerQueueElement<OWNER> tail = this;

        OwnerQueueElement(OWNER owner) {
            this.owner = owner;
        }

        synchronized boolean enqueue(OwnerQueueElement<OWNER> last) {
            if (this.owner == null) {
                return false;
            }
            last.head = this;
            last.tail = this;
            this.tail.tail = last;
            this.tail = last;
            if (this.head == this) {
                this.head = last;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized OWNER dequeue() {
            OwnerQueueElement<OWNER> first = this.head;
            this.head = first.tail;
            first.tail.head = this;
            first.tail = this;
            if (this.head == this) {
                this.tail = this;
            }
            try {
                OWNER OWNER = this.owner = first.owner;
                return OWNER;
            }
            finally {
                first.owner = null;
            }
        }

        public String toString() {
            return String.format("%s*%s", this.count, this.owner);
        }
    }
}

