/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.logging.Log;

public class MeasureDoNothing
extends Thread {
    private volatile boolean measure = true;
    private final long TIME_TO_WAIT;
    private final long NOTIFICATION_THRESHOLD;
    private final Log log;

    public MeasureDoNothing(String threadName, Log log, long timeToWait, long pauseNotificationThreshold) {
        super(threadName);
        if (log == null) {
            throw new IllegalArgumentException("Null message log");
        }
        this.log = log;
        this.TIME_TO_WAIT = timeToWait;
        this.NOTIFICATION_THRESHOLD = pauseNotificationThreshold + timeToWait;
        this.setDaemon(true);
    }

    @Override
    public synchronized void run() {
        this.log.debug("GC Monitor started. ");
        while (this.measure) {
            long time;
            long start = System.nanoTime();
            try {
                this.wait(this.TIME_TO_WAIT);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            if ((time = (System.nanoTime() - start) / 1000000L) <= this.NOTIFICATION_THRESHOLD) continue;
            long blockTime = time - this.TIME_TO_WAIT;
            this.log.warn(String.format("GC Monitor: Application threads blocked for %dms.", blockTime));
        }
        this.log.debug("GC Monitor stopped. ");
    }

    public synchronized void stopMeasuring() {
        this.measure = false;
        this.interrupt();
    }
}

