/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.direct;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.lifecycle.LifeSupport;

public class DirectStoreAccess
implements Closeable {
    private final LifeSupport life = new LifeSupport();
    private final StoreAccess nativeStores;
    private final LabelScanStore labelScanStore;
    private final SchemaIndexProvider indexes;

    public DirectStoreAccess(StoreAccess nativeStores, LabelScanStore labelScanStore, SchemaIndexProvider indexes) {
        this.nativeStores = nativeStores;
        this.labelScanStore = labelScanStore;
        this.indexes = this.life.add(indexes);
    }

    public StoreAccess nativeStores() {
        return this.nativeStores;
    }

    public LabelScanStore labelScanStore() {
        return this.labelScanStore;
    }

    public SchemaIndexProvider indexes() {
        return this.indexes;
    }

    @Override
    public void close() throws IOException {
        this.nativeStores.close();
        this.labelScanStore.shutdown();
        this.life.shutdown();
    }
}

