/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

interface ByteCodeVisitor {
    public static final ByteCodeVisitor DO_NOTHING = new ByteCodeVisitor(){

        @Override
        public void visitByteCode(String name, ByteBuffer bytes) {
        }
    };

    public void visitByteCode(String var1, ByteBuffer var2);

    public static class Printer
    extends ClassVisitor
    implements ByteCodeVisitor {
        public static final int API = 262144;
        private final PrintStream out;

        Printer(PrintStream out) {
            super(262144);
            this.out = out;
        }

        @Override
        public void visitByteCode(String name, ByteBuffer bytes) {
            new ClassReader(bytes.array()).accept((ClassVisitor)this, 0);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            StringBuilder iFaces = new StringBuilder();
            String prefix = " implements ";
            for (String iFace : interfaces) {
                iFaces.append(prefix).append(iFace);
                prefix = ", ";
            }
            this.out.format("%s class %s extends %s%s%n{%n", Modifier.toString(access), name, superName, iFaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.out.format("%s %s %s%s;", Modifier.toString(access), desc, name, value == null ? "" : " = " + value);
            return super.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.out.format("  %s %s%s%n  {%n", Modifier.toString(access), name, desc);
            return new MethodVisitor(262144){

                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    int i;
                    StringBuilder frame = new StringBuilder().append("    [FRAME:");
                    switch (type) {
                        case -1: {
                            frame.append("NEW");
                            break;
                        }
                        case 0: {
                            frame.append("FULL");
                            break;
                        }
                        case 1: {
                            frame.append("APPEND");
                            break;
                        }
                        case 2: {
                            frame.append("CHOP");
                            break;
                        }
                        case 3: {
                            frame.append("SAME");
                            break;
                        }
                        case 4: {
                            frame.append("SAME1");
                            break;
                        }
                        default: {
                            frame.append(type);
                        }
                    }
                    frame.append(", ").append(nLocal).append(" locals: [");
                    String prefix = "";
                    for (i = 0; i < nLocal; ++i) {
                        frame.append(prefix);
                        if (local[i] instanceof String) {
                            frame.append(local[i]);
                        } else if (local[i] == Opcodes.TOP) {
                            frame.append("TOP");
                        } else if (local[i] == Opcodes.INTEGER) {
                            frame.append("INTEGER");
                        } else if (local[i] == Opcodes.FLOAT) {
                            frame.append("FLOAT");
                        } else if (local[i] == Opcodes.DOUBLE) {
                            frame.append("DOUBLE");
                        } else if (local[i] == Opcodes.LONG) {
                            frame.append("LONG");
                        } else if (local[i] == Opcodes.NULL) {
                            frame.append("NULL");
                        } else if (local[i] == Opcodes.UNINITIALIZED_THIS) {
                            frame.append("UNINITIALIZED_THIS");
                        } else {
                            frame.append(local[i]);
                        }
                        prefix = ", ";
                    }
                    frame.append("], ").append(nStack).append(" items on stack: [");
                    prefix = "";
                    for (i = 0; i < nStack; ++i) {
                        frame.append(prefix).append(Objects.toString(stack[i]));
                        prefix = ", ";
                    }
                    Printer.this.out.println(frame.append("]"));
                }

                public void visitInsn(int opcode) {
                    Printer.this.out.format("    %s%n", Printer.opcode(opcode));
                }

                public void visitIntInsn(int opcode, int operand) {
                    Printer.this.out.format("    %s %d%n", Printer.opcode(opcode), operand);
                }

                public void visitVarInsn(int opcode, int var) {
                    Printer.this.out.format("    %s var:%d%n", Printer.opcode(opcode), var);
                }

                public void visitTypeInsn(int opcode, String type) {
                    Printer.this.out.format("    %s %s%n", Printer.opcode(opcode), type);
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    Printer.this.out.format("    %s %s.%s:%s%n", Printer.opcode(opcode), owner, name, desc);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    Printer.this.out.format("    %s %s.%s%s%n", Printer.opcode(opcode), owner, name, desc);
                }

                public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                    Printer.this.out.format("    InvokeDynamic %s%s / bsm:%s%s%n", name, desc, bsm, Arrays.toString(bsmArgs));
                }

                public void visitJumpInsn(int opcode, Label label) {
                    Printer.this.out.format("    %s %s%n", Printer.opcode(opcode), label);
                }

                public void visitLabel(Label label) {
                    Printer.this.out.format("   %s:%n", label);
                }

                public void visitLdcInsn(Object cst) {
                    Printer.this.out.format("    LDC %s%n", cst);
                }

                public void visitIincInsn(int var, int increment) {
                    Printer.this.out.format("    IINC %d += %d%n", var, increment);
                }

                public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                    Printer.this.out.format("    TABLE_SWITCH(min=%d, max=%d)%n    {%n", min, max);
                    int i = 0;
                    int val = min;
                    while (i < labels.length) {
                        Printer.this.out.format("      case %d goto %s%n", val, labels[i]);
                        ++i;
                        ++val;
                    }
                    Printer.this.out.printf("      default goto %s%n    }%n", dflt);
                }

                public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                    Printer.this.out.format("    LOOKUP_SWITCH%n    {%n", new Object[0]);
                    for (int i = 0; i < labels.length; ++i) {
                        Printer.this.out.format("      case %d goto %s%n", keys[i], labels[i]);
                    }
                    Printer.this.out.printf("      default goto %s%n    }%n", dflt);
                }

                public void visitMultiANewArrayInsn(String desc, int dims) {
                    Printer.this.out.format("    MULTI_ANEW_ARRAY %s, dims:%d%n", desc, dims);
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    Printer.this.out.format("    [try/catch %s start@%s, end@%s, handler@%s]%n", type, start, end, handler);
                }

                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    Printer.this.out.format("    [local %s:%s, from %s to %s @offset=%d]%n", name, desc, start, end, index);
                }

                public void visitLineNumber(int line, Label start) {
                    Printer.this.out.format("    [line %d @ %s]%n", line, start);
                }

                public void visitEnd() {
                    Printer.this.out.println("  }");
                }
            };
        }

        private static String opcode(int opcode) {
            switch (opcode) {
                case 0: {
                    return "NOP";
                }
                case 1: {
                    return "ACONST_NULL";
                }
                case 2: {
                    return "ICONST_M1";
                }
                case 3: {
                    return "ICONST_0";
                }
                case 4: {
                    return "ICONST_1";
                }
                case 5: {
                    return "ICONST_2";
                }
                case 6: {
                    return "ICONST_3";
                }
                case 7: {
                    return "ICONST_4";
                }
                case 8: {
                    return "ICONST_5";
                }
                case 9: {
                    return "LCONST_0";
                }
                case 10: {
                    return "LCONST_1";
                }
                case 11: {
                    return "FCONST_0";
                }
                case 12: {
                    return "FCONST_1";
                }
                case 13: {
                    return "FCONST_2";
                }
                case 14: {
                    return "DCONST_0";
                }
                case 15: {
                    return "DCONST_1";
                }
                case 46: {
                    return "IALOAD";
                }
                case 47: {
                    return "LALOAD";
                }
                case 48: {
                    return "FALOAD";
                }
                case 49: {
                    return "DALOAD";
                }
                case 50: {
                    return "AALOAD";
                }
                case 51: {
                    return "BALOAD";
                }
                case 52: {
                    return "CALOAD";
                }
                case 53: {
                    return "SALOAD";
                }
                case 79: {
                    return "IASTORE";
                }
                case 80: {
                    return "LASTORE";
                }
                case 81: {
                    return "FASTORE";
                }
                case 82: {
                    return "DASTORE";
                }
                case 83: {
                    return "AASTORE";
                }
                case 84: {
                    return "BASTORE";
                }
                case 85: {
                    return "CASTORE";
                }
                case 86: {
                    return "SASTORE";
                }
                case 87: {
                    return "POP";
                }
                case 88: {
                    return "POP2";
                }
                case 89: {
                    return "DUP";
                }
                case 90: {
                    return "DUP_X1";
                }
                case 91: {
                    return "DUP_X2";
                }
                case 92: {
                    return "DUP2";
                }
                case 93: {
                    return "DUP2_X1";
                }
                case 94: {
                    return "DUP2_X2";
                }
                case 95: {
                    return "SWAP";
                }
                case 96: {
                    return "IADD";
                }
                case 97: {
                    return "LADD";
                }
                case 98: {
                    return "FADD";
                }
                case 99: {
                    return "DADD";
                }
                case 100: {
                    return "ISUB";
                }
                case 101: {
                    return "LSUB";
                }
                case 102: {
                    return "FSUB";
                }
                case 103: {
                    return "DSUB";
                }
                case 104: {
                    return "IMUL";
                }
                case 105: {
                    return "LMUL";
                }
                case 106: {
                    return "FMUL";
                }
                case 107: {
                    return "DMUL";
                }
                case 108: {
                    return "IDIV";
                }
                case 109: {
                    return "LDIV";
                }
                case 110: {
                    return "FDIV";
                }
                case 111: {
                    return "DDIV";
                }
                case 112: {
                    return "IREM";
                }
                case 113: {
                    return "LREM";
                }
                case 114: {
                    return "FREM";
                }
                case 115: {
                    return "DREM";
                }
                case 116: {
                    return "INEG";
                }
                case 117: {
                    return "LNEG";
                }
                case 118: {
                    return "FNEG";
                }
                case 119: {
                    return "DNEG";
                }
                case 120: {
                    return "ISHL";
                }
                case 121: {
                    return "LSHL";
                }
                case 122: {
                    return "ISHR";
                }
                case 123: {
                    return "LSHR";
                }
                case 124: {
                    return "IUSHR";
                }
                case 125: {
                    return "LUSHR";
                }
                case 126: {
                    return "IAND";
                }
                case 127: {
                    return "LAND";
                }
                case 128: {
                    return "IOR";
                }
                case 129: {
                    return "LOR";
                }
                case 130: {
                    return "IXOR";
                }
                case 131: {
                    return "LXOR";
                }
                case 133: {
                    return "I2L";
                }
                case 134: {
                    return "I2F";
                }
                case 135: {
                    return "I2D";
                }
                case 136: {
                    return "L2I";
                }
                case 137: {
                    return "L2F";
                }
                case 138: {
                    return "L2D";
                }
                case 139: {
                    return "F2I";
                }
                case 140: {
                    return "F2L";
                }
                case 141: {
                    return "F2D";
                }
                case 142: {
                    return "D2I";
                }
                case 143: {
                    return "D2L";
                }
                case 144: {
                    return "D2F";
                }
                case 145: {
                    return "I2B";
                }
                case 146: {
                    return "I2C";
                }
                case 147: {
                    return "I2S";
                }
                case 148: {
                    return "LCMP";
                }
                case 149: {
                    return "FCMPL";
                }
                case 150: {
                    return "FCMPG";
                }
                case 151: {
                    return "DCMPL";
                }
                case 152: {
                    return "DCMPG";
                }
                case 172: {
                    return "IRETURN";
                }
                case 173: {
                    return "LRETURN";
                }
                case 174: {
                    return "FRETURN";
                }
                case 175: {
                    return "DRETURN";
                }
                case 176: {
                    return "ARETURN";
                }
                case 177: {
                    return "RETURN";
                }
                case 190: {
                    return "ARRAYLENGTH";
                }
                case 191: {
                    return "ATHROW";
                }
                case 194: {
                    return "MONITORENTER";
                }
                case 195: {
                    return "MONITOREXIT";
                }
                case 16: {
                    return "BIPUSH";
                }
                case 17: {
                    return "SIPUSH";
                }
                case 188: {
                    return "NEWARRAY";
                }
                case 21: {
                    return "ILOAD";
                }
                case 22: {
                    return "LLOAD";
                }
                case 23: {
                    return "FLOAD";
                }
                case 24: {
                    return "DLOAD";
                }
                case 25: {
                    return "ALOAD";
                }
                case 54: {
                    return "ISTORE";
                }
                case 55: {
                    return "LSTORE";
                }
                case 56: {
                    return "FSTORE";
                }
                case 57: {
                    return "DSTORE";
                }
                case 58: {
                    return "ASTORE";
                }
                case 169: {
                    return "RET";
                }
                case 187: {
                    return "NEW";
                }
                case 189: {
                    return "ANEWARRAY";
                }
                case 192: {
                    return "CHECKCAST";
                }
                case 193: {
                    return "INSTANCEOF";
                }
                case 178: {
                    return "GETSTATIC";
                }
                case 179: {
                    return "PUTSTATIC";
                }
                case 180: {
                    return "GETFIELD";
                }
                case 181: {
                    return "PUTFIELD";
                }
                case 182: {
                    return "INVOKEVIRTUAL";
                }
                case 183: {
                    return "INVOKESPECIAL";
                }
                case 184: {
                    return "INVOKESTATIC";
                }
                case 185: {
                    return "INVOKEINTERFACE";
                }
                case 153: {
                    return "IFEQ";
                }
                case 154: {
                    return "IFNE";
                }
                case 155: {
                    return "IFLT";
                }
                case 156: {
                    return "IFGE";
                }
                case 157: {
                    return "IFGT";
                }
                case 158: {
                    return "IFLE";
                }
                case 159: {
                    return "IF_ICMPEQ";
                }
                case 160: {
                    return "IF_ICMPNE";
                }
                case 161: {
                    return "IF_ICMPLT";
                }
                case 162: {
                    return "IF_ICMPGE";
                }
                case 163: {
                    return "IF_ICMPGT";
                }
                case 164: {
                    return "IF_ICMPLE";
                }
                case 165: {
                    return "IF_ACMPEQ";
                }
                case 166: {
                    return "IF_ACMPNE";
                }
                case 167: {
                    return "GOTO";
                }
                case 168: {
                    return "JSR";
                }
                case 198: {
                    return "IFNULL";
                }
                case 199: {
                    return "IFNONNULL";
                }
            }
            throw new IllegalArgumentException("unknown opcode: " + opcode);
        }

        public void visitEnd() {
            this.out.println("}");
        }
    }

    public static class Multiplex
    implements ByteCodeVisitor {
        private final ByteCodeVisitor[] visitors;

        public Multiplex(ByteCodeVisitor[] visitors) {
            this.visitors = visitors;
        }

        @Override
        public void visitByteCode(String name, ByteBuffer bytes) {
            for (ByteCodeVisitor visitor : this.visitors) {
                visitor.visitByteCode(name, bytes.duplicate());
            }
        }
    }

    public static interface Configurable {
        public void addByteCodeVisitor(ByteCodeVisitor var1);
    }
}

