/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.javaee6.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.javaee6.api.model.JsfFaceletDescriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class JsfFaceletScannerPlugin
extends AbstractScannerPlugin<FileResource, JsfFaceletDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsfFaceletScannerPlugin.class);
    private static final String DEFAULT_FILE_PATTERN = ".*\\.jspx";
    private static final String PROPERTY_NAME_FILE_PATTERN = "facelet.file.pattern";
    private DocumentBuilder documentBuilder;
    private Pattern filePattern;
    private XPath xPath;

    public void initialize() {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        this.xPath = xPathfactory.newXPath();
        this.xPath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix != null) {
                    switch (prefix) {
                        case "": {
                            return "http://www.w3.org/1999/xhtml";
                        }
                        case "ui": {
                            return "http://java.sun.com/jsf/facelets";
                        }
                        case "h": {
                            return "http://java.sun.com/jsf/html";
                        }
                        case "f": {
                            return "http://java.sun.com/jsf/core";
                        }
                    }
                }
                return "";
            }
        });
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn("Cannot set features of document builder factory.", (Throwable)e);
        }
        try {
            this.documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot create document builder.", e);
        }
    }

    public void configure() {
        this.filePattern = this.getProperties().containsKey(PROPERTY_NAME_FILE_PATTERN) ? Pattern.compile(this.getProperties().get(PROPERTY_NAME_FILE_PATTERN).toString()) : Pattern.compile(DEFAULT_FILE_PATTERN);
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return this.filePattern.matcher(path).matches();
    }

    public JsfFaceletDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        Store store = context.getStore();
        FileDescriptor fileDescriptor = (FileDescriptor)context.peek(FileDescriptor.class);
        JsfFaceletDescriptor currentDescriptor = (JsfFaceletDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, JsfFaceletDescriptor.class);
        try {
            Document doc = this.getDocument(item);
            NodeList nodeList = (NodeList)this.getXPath().evaluate("//ui:include", doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String includeSrc = node.getAttributes().getNamedItem("src").getNodeValue();
                JsfFaceletDescriptor includedJsf = this.findJsfTemplateDescriptor(path, includeSrc, context);
                if (includedJsf == null) continue;
                currentDescriptor.getIncludes().add(includedJsf);
            }
            String templateSrc = (String)this.getXPath().evaluate("//ui:composition/@template", doc, XPathConstants.STRING);
            if (StringUtils.isNotBlank((String)templateSrc)) {
                currentDescriptor.setTemplate(this.findJsfTemplateDescriptor(path, templateSrc, context));
            }
        }
        catch (XPathExpressionException | SAXException e) {
            throw new IOException(e);
        }
        return currentDescriptor;
    }

    private JsfFaceletDescriptor findJsfTemplateDescriptor(String templateFqn, String path, ScannerContext context) {
        String includedFile = this.absolutifyFilePath(path, templateFqn);
        return this.getJsfTemplateDescriptor(includedFile, context);
    }

    private String normalizeFilePath(String path) {
        String normalizedPath = path.replace('\\', '/');
        if (!normalizedPath.startsWith("/")) {
            normalizedPath = "/" + normalizedPath;
        }
        return normalizedPath;
    }

    private String absolutifyFilePath(String path, String referencePath) {
        String normalizedPath;
        if (this.isElExpression(path)) {
            return path;
        }
        if (!path.startsWith("/")) {
            Path reference = Paths.get(referencePath, new String[0]);
            normalizedPath = reference.getParent().resolve(path).normalize().toString();
        } else {
            normalizedPath = Paths.get(path, new String[0]).normalize().toString();
        }
        return this.normalizeFilePath(normalizedPath);
    }

    private Document getDocument(FileResource resource) throws SAXException, IOException {
        return this.documentBuilder.parse(resource.getFile());
    }

    private JsfFaceletDescriptor getJsfTemplateDescriptor(String fullFilePath, ScannerContext context) {
        if (this.isElExpression(fullFilePath)) {
            return null;
        }
        return (JsfFaceletDescriptor)((FileResolver)context.peek(FileResolver.class)).require(fullFilePath, JsfFaceletDescriptor.class, context);
    }

    private boolean isElExpression(String str) {
        return str.startsWith("#{") || str.startsWith("${");
    }

    private XPath getXPath() {
        return this.xPath;
    }
}

