/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.AbstractPluginRepository;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.plugin.schema.v1.ScannerType;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScannerPluginRepositoryImpl
extends AbstractPluginRepository
implements ScannerPluginRepository {
    private final List<ScannerPlugin<?, ?>> scannerPlugins;

    public ScannerPluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) throws PluginRepositoryException {
        super(pluginConfigurationReader);
        List<JqassistantPlugin> plugins = pluginConfigurationReader.getPlugins();
        this.scannerPlugins = this.getScannerPlugins(plugins);
    }

    @Override
    public List<ScannerPlugin<?, ?>> getScannerPlugins(ScannerContext scannerContext, Map<String, Object> properties) throws PluginRepositoryException {
        for (ScannerPlugin<?, ?> scannerPlugin : this.scannerPlugins) {
            scannerPlugin.configure(scannerContext, new HashMap<String, Object>(properties));
        }
        return this.scannerPlugins;
    }

    private <T extends ScannerPlugin> List<T> getScannerPlugins(List<JqassistantPlugin> plugins) throws PluginRepositoryException {
        ArrayList<ScannerPlugin> scannerPlugins = new ArrayList<ScannerPlugin>();
        for (JqassistantPlugin plugin : plugins) {
            ScannerType scannerType = plugin.getScanner();
            if (scannerType == null) continue;
            for (String scannerPluginName : scannerType.getClazz()) {
                ScannerPlugin scannerPlugin = (ScannerPlugin)this.createInstance(scannerPluginName);
                if (scannerPlugin == null) continue;
                scannerPlugin.initialize();
                scannerPlugins.add(scannerPlugin);
            }
        }
        return scannerPlugins;
    }
}

