/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.analysis.impl.XmlHelper;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.plugin.schema.v1.ObjectFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigurationReaderImpl
implements PluginConfigurationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginConfigurationReaderImpl.class);
    private static final JAXBContext jaxbContext;
    private static final Schema schema;
    private final ClassLoader pluginClassLoader;
    private List<JqassistantPlugin> plugins = null;

    public PluginConfigurationReaderImpl() {
        this(PluginConfigurationReader.class.getClassLoader());
    }

    public PluginConfigurationReaderImpl(ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JqassistantPlugin readPlugin(URL pluginUrl) {
        try (BufferedInputStream inputStream = new BufferedInputStream(pluginUrl.openStream());){
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            JqassistantPlugin jqassistantPlugin = (JqassistantPlugin)unmarshaller.unmarshal((Source)new StreamSource(inputStream), JqassistantPlugin.class).getValue();
            return jqassistantPlugin;
        }
        catch (IOException | JAXBException e) {
            throw new IllegalStateException("Cannot read plugin from " + pluginUrl.toString(), e);
        }
    }

    @Override
    public List<JqassistantPlugin> getPlugins() {
        if (this.plugins == null) {
            Enumeration<URL> resources;
            try {
                resources = this.pluginClassLoader.getResources("META-INF/jqassistant-plugin.xml");
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get plugin resources.", e);
            }
            this.plugins = new ArrayList<JqassistantPlugin>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LOGGER.debug("Reading plugin descriptor from '{}'.", (Object)url);
                this.plugins.add(this.readPlugin(url));
            }
            TreeSet<String> pluginNames = new TreeSet<String>();
            for (JqassistantPlugin plugin : this.plugins) {
                pluginNames.add(plugin.getName());
            }
            LOGGER.info("Loaded jQAssistant plugins {}.", pluginNames);
        }
        return this.plugins;
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Cannot create JAXB context.", e);
        }
        schema = XmlHelper.getSchema((String)"/META-INF/xsd/jqassistant-plugin-1.0.xsd");
    }
}

