/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import org.osgi.framework.Version;

public class EEVersion
implements Comparable<EEVersion> {
    private Version version;
    private EEType type;

    public EEVersion(Version version, EEType type) {
        this.version = version;
        this.type = type;
    }

    @Override
    public int compareTo(EEVersion other) {
        Version JAVA8 = Version.parseVersion((String)"1.8");
        if (this.type.equals((Object)EEType.JAVA_SE) && this.version.equals((Object)JAVA8) && other.type.profileName.contains("JavaSE/compact")) {
            return 1;
        }
        if (other.type.equals((Object)EEType.JAVA_SE) && other.version.equals((Object)JAVA8) && this.type.profileName.contains("JavaSE/compact")) {
            return -1;
        }
        int result = this.type.compareTo(other.type);
        if (result != 0) {
            return result;
        }
        return this.version.compareTo(other.version);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof EEVersion)) {
            return false;
        }
        EEVersion o = (EEVersion)other;
        return this.version.equals((Object)o.version) && this.type.equals((Object)o.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public static enum EEType {
        OSGI_MINIMUM("OSGi/Minimum"),
        CDC_FOUNDATION("CDC/Foundation"),
        JRE("JRE"),
        JAVA_SE("JavaSE"),
        JAVA_SE_COMPACT1("JavaSE/compact1"),
        JAVA_SE_COMPACT2("JavaSE/compact2"),
        JAVA_SE_COMPACT3("JavaSE/compact3");

        private final String profileName;

        private EEType(String profileName) {
            this.profileName = profileName;
        }

        public static EEType fromName(String profileName) {
            for (EEType type : EEType.values()) {
                if (!type.profileName.equals(profileName)) continue;
                return type;
            }
            return null;
        }
    }
}

