/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotatedDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ConstructorDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InvokesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ReadsDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.WritesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;

public class VisitorHelper {
    private static final String CONSTRUCTOR_METHOD = "void <init>";
    private ScannerContext scannerContext;

    public VisitorHelper(ScannerContext scannerContext) {
        this.scannerContext = scannerContext;
    }

    TypeCache.CachedType resolveType(String fullQualifiedName, TypeCache.CachedType<? extends ClassFileDescriptor> dependentType) {
        TypeDescriptor dependency;
        TypeCache.CachedType<TypeDescriptor> cachedType = this.getTypeResolver().resolve(fullQualifiedName, this.scannerContext);
        if (!dependentType.equals(cachedType) && (dependency = dependentType.getDependency(fullQualifiedName)) == null) {
            dependency = cachedType.getTypeDescriptor();
            dependentType.addDependency(fullQualifiedName, dependency);
        }
        return cachedType;
    }

    <T extends ClassFileDescriptor> TypeCache.CachedType<T> createType(String fullQualifiedName, FileDescriptor fileDescriptor, Class<T> descriptorType) {
        return this.getTypeResolver().create(fullQualifiedName, fileDescriptor, descriptorType, this.scannerContext);
    }

    private TypeResolver getTypeResolver() {
        TypeResolver typeResolver = (TypeResolver)this.scannerContext.peek(TypeResolver.class);
        if (typeResolver == null) {
            throw new IllegalStateException("Cannot find Java type resolver.");
        }
        return typeResolver;
    }

    MethodDescriptor getMethodDescriptor(TypeCache.CachedType<?> cachedType, String signature) {
        MethodDescriptor methodDescriptor = cachedType.getMethod(signature);
        if (methodDescriptor == null) {
            methodDescriptor = signature.startsWith(CONSTRUCTOR_METHOD) ? (MethodDescriptor)this.scannerContext.getStore().create(ConstructorDescriptor.class) : (MethodDescriptor)this.scannerContext.getStore().create(MethodDescriptor.class);
            methodDescriptor.setSignature(signature);
            cachedType.addMember(signature, methodDescriptor);
        }
        return methodDescriptor;
    }

    public ParameterDescriptor addParameterDescriptor(MethodDescriptor methodDescriptor, int index) {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.scannerContext.getStore().create(ParameterDescriptor.class);
        parameterDescriptor.setIndex(index);
        methodDescriptor.getParameters().add(parameterDescriptor);
        return parameterDescriptor;
    }

    public ParameterDescriptor getParameterDescriptor(MethodDescriptor methodDescriptor, int index) {
        for (ParameterDescriptor parameterDescriptor : methodDescriptor.getParameters()) {
            if (parameterDescriptor.getIndex() != index) continue;
            return parameterDescriptor;
        }
        return null;
    }

    public void addInvokes(MethodDescriptor methodDescriptor, int lineNumber, MethodDescriptor invokedMethodDescriptor) {
        InvokesDescriptor invokesDescriptor = (InvokesDescriptor)this.scannerContext.getStore().create((Descriptor)methodDescriptor, InvokesDescriptor.class, (Descriptor)invokedMethodDescriptor);
        invokesDescriptor.setLineNumber(lineNumber);
    }

    public void addReads(MethodDescriptor methodDescriptor, int lineNumber, FieldDescriptor fieldDescriptor) {
        ReadsDescriptor readsDescriptor = (ReadsDescriptor)this.scannerContext.getStore().create((Descriptor)methodDescriptor, ReadsDescriptor.class, (Descriptor)fieldDescriptor);
        readsDescriptor.setLineNumber(lineNumber);
    }

    public void addWrites(MethodDescriptor methodDescriptor, int lineNumber, FieldDescriptor fieldDescriptor) {
        WritesDescriptor writesDescriptor = (WritesDescriptor)this.scannerContext.getStore().create((Descriptor)methodDescriptor, WritesDescriptor.class, (Descriptor)fieldDescriptor);
        writesDescriptor.setLineNumber(lineNumber);
    }

    FieldDescriptor getFieldDescriptor(TypeCache.CachedType<?> cachedType, String signature) {
        FieldDescriptor fieldDescriptor = cachedType.getField(signature);
        if (fieldDescriptor == null) {
            fieldDescriptor = (FieldDescriptor)this.scannerContext.getStore().create(FieldDescriptor.class);
            fieldDescriptor.setSignature(signature);
            cachedType.addMember(signature, fieldDescriptor);
        }
        return fieldDescriptor;
    }

    <T extends ValueDescriptor<?>> T getValueDescriptor(Class<T> valueDescriptorType) {
        return (T)((ValueDescriptor)this.scannerContext.getStore().create(valueDescriptorType));
    }

    AnnotationValueDescriptor addAnnotation(TypeCache.CachedType containingDescriptor, AnnotatedDescriptor annotatedDescriptor, String typeName) {
        if (typeName != null) {
            Object type = this.resolveType(typeName, containingDescriptor).getTypeDescriptor();
            AnnotationValueDescriptor annotationDescriptor = (AnnotationValueDescriptor)this.scannerContext.getStore().create(AnnotationValueDescriptor.class);
            annotationDescriptor.setType((TypeDescriptor)type);
            annotatedDescriptor.getAnnotatedBy().add(annotationDescriptor);
            return annotationDescriptor;
        }
        return null;
    }
}

