/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AbstractTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.DependentTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodSignatureVisitor
extends SignatureVisitor {
    private TypeCache.CachedType containingType;
    private MethodDescriptor methodDescriptor;
    private VisitorHelper visitorHelper;
    private int parameterIndex = 0;

    MethodSignatureVisitor(TypeCache.CachedType containingType, MethodDescriptor methodDescriptor, VisitorHelper visitorHelper) {
        super(327680);
        this.containingType = containingType;
        this.methodDescriptor = methodDescriptor;
        this.visitorHelper = visitorHelper;
    }

    public SignatureVisitor visitClassBound() {
        return new DependentTypeSignatureVisitor(this.containingType, this.visitorHelper);
    }

    public SignatureVisitor visitInterfaceBound() {
        return new DependentTypeSignatureVisitor(this.containingType, this.visitorHelper);
    }

    public SignatureVisitor visitParameterType() {
        final ParameterDescriptor parameterDescriptor = this.visitorHelper.addParameterDescriptor(this.methodDescriptor, this.parameterIndex);
        ++this.parameterIndex;
        return new AbstractTypeSignatureVisitor<ParameterDescriptor>(this.containingType, this.visitorHelper){

            public SignatureVisitor visitArrayType() {
                return new DependentTypeSignatureVisitor(MethodSignatureVisitor.this.containingType, MethodSignatureVisitor.this.visitorHelper);
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new DependentTypeSignatureVisitor(MethodSignatureVisitor.this.containingType, MethodSignatureVisitor.this.visitorHelper);
            }

            @Override
            public void visitEnd(TypeDescriptor resolvedTypeDescriptor) {
                parameterDescriptor.setType(resolvedTypeDescriptor);
            }
        };
    }

    public SignatureVisitor visitReturnType() {
        return new AbstractTypeSignatureVisitor<MethodDescriptor>(this.containingType, this.visitorHelper){

            public SignatureVisitor visitArrayType() {
                return new DependentTypeSignatureVisitor(MethodSignatureVisitor.this.containingType, MethodSignatureVisitor.this.visitorHelper);
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new DependentTypeSignatureVisitor(MethodSignatureVisitor.this.containingType, MethodSignatureVisitor.this.visitorHelper);
            }

            @Override
            public void visitEnd(TypeDescriptor resolvedTypeDescriptor) {
                MethodSignatureVisitor.this.methodDescriptor.setReturns(resolvedTypeDescriptor);
            }
        };
    }

    public SignatureVisitor visitExceptionType() {
        return new DependentTypeSignatureVisitor(this.containingType, this.visitorHelper);
    }
}

