/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DirectoryDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.DirectoryResource;
import com.buschmais.jqassistant.plugin.java.api.model.PackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import java.io.IOException;

@ScannerPlugin.Requires(value={DirectoryDescriptor.class})
public class PackageDirectoryScannerPlugin
extends AbstractScannerPlugin<DirectoryResource, PackageDescriptor> {
    public boolean accepts(DirectoryResource item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals(scope) && path != null && !path.startsWith("/META-INF");
    }

    public PackageDescriptor scan(DirectoryResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        DirectoryDescriptor directoryDescriptor = (DirectoryDescriptor)context.peek(DirectoryDescriptor.class);
        PackageDescriptor descriptor = (PackageDescriptor)context.getStore().addDescriptorType((Descriptor)directoryDescriptor, PackageDescriptor.class);
        String packageName = path.substring(1).replaceAll("/", ".");
        int separatorIndex = packageName.lastIndexOf(46);
        String name = separatorIndex != -1 ? packageName.substring(separatorIndex + 1) : packageName;
        descriptor.setName(name);
        descriptor.setFullQualifiedName(packageName);
        return descriptor;
    }
}

