/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.ClasspathScopedTypeResolver;
import com.buschmais.jqassistant.plugin.java.api.scanner.DefaultTypeResolver;
import com.buschmais.jqassistant.plugin.java.api.scanner.DelegatingTypeResolver;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;

public enum JavaScope implements Scope
{
    CLASSPATH{

        public void onEnter(ScannerContext context) {
            TypeResolver typeResolver = this.getTypeResolver(context);
            context.push(TypeResolver.class, (Object)typeResolver);
        }

        public void onLeave(ScannerContext context) {
            context.pop(TypeResolver.class);
        }

        private TypeResolver getTypeResolver(ScannerContext context) {
            TypeResolver typeResolver = (TypeResolver)context.peekOrDefault(TypeResolver.class, null);
            if (typeResolver != null) {
                return new DelegatingTypeResolver(typeResolver);
            }
            JavaArtifactFileDescriptor artifactDescriptor = (JavaArtifactFileDescriptor)context.peekOrDefault(JavaArtifactFileDescriptor.class, null);
            if (artifactDescriptor != null) {
                return new ClasspathScopedTypeResolver(artifactDescriptor);
            }
            return new DefaultTypeResolver();
        }
    };


    public String getPrefix() {
        return "java";
    }

    public String getName() {
        return this.name();
    }
}

