/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.jpa2.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.PropertyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.jpa2.api.model.PersistenceUnitDescriptor;
import com.buschmais.jqassistant.plugin.jpa2.api.model.PersistenceXmlDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.AbstractXmlFileScannerPlugin;
import com.buschmais.jqassistant.plugin.xml.api.scanner.JAXBUnmarshaller;
import java.io.IOException;
import java.util.HashMap;
import org.jcp.xmlns.xml.ns.persistence.Persistence;
import org.jcp.xmlns.xml.ns.persistence.PersistenceUnitCachingType;
import org.jcp.xmlns.xml.ns.persistence.PersistenceUnitTransactionType;
import org.jcp.xmlns.xml.ns.persistence.PersistenceUnitValidationModeType;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class PersistenceXmlScannerPlugin
extends AbstractXmlFileScannerPlugin<PersistenceXmlDescriptor> {
    private JAXBUnmarshaller<Persistence> unmarshaller;

    public void initialize() {
        HashMap<String, String> namespaceMapping = new HashMap<String, String>();
        namespaceMapping.put("http://java.sun.com/xml/ns/persistence", "http://xmlns.jcp.org/xml/ns/persistence");
        this.unmarshaller = new JAXBUnmarshaller(Persistence.class, namespaceMapping);
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals((Object)scope) && "/META-INF/persistence.xml".equals(path) || "/WEB-INF/persistence.xml".equals(path);
    }

    public PersistenceXmlDescriptor scan(FileResource item, PersistenceXmlDescriptor persistenceXmlDescriptor, String path, Scope scope, Scanner scanner) throws IOException {
        Store store = scanner.getContext().getStore();
        Persistence persistence = (Persistence)this.unmarshaller.unmarshal(item);
        persistenceXmlDescriptor.setVersion(persistence.getVersion());
        for (Persistence.PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
            PersistenceUnitCachingType sharedCacheMode;
            PersistenceUnitDescriptor persistenceUnitDescriptor = (PersistenceUnitDescriptor)store.create(PersistenceUnitDescriptor.class);
            persistenceUnitDescriptor.setName(persistenceUnit.getName());
            PersistenceUnitTransactionType transactionType = persistenceUnit.getTransactionType();
            if (transactionType != null) {
                persistenceUnitDescriptor.setTransactionType(transactionType.name());
            }
            persistenceUnitDescriptor.setDescription(persistenceUnit.getDescription());
            persistenceUnitDescriptor.setJtaDataSource(persistenceUnit.getJtaDataSource());
            persistenceUnitDescriptor.setNonJtaDataSource(persistenceUnit.getNonJtaDataSource());
            persistenceUnitDescriptor.setProvider(persistenceUnit.getProvider());
            PersistenceUnitValidationModeType validationMode = persistenceUnit.getValidationMode();
            if (validationMode != null) {
                persistenceUnitDescriptor.setValidationMode(validationMode.name());
            }
            if ((sharedCacheMode = persistenceUnit.getSharedCacheMode()) != null) {
                persistenceUnitDescriptor.setSharedCacheMode(sharedCacheMode.name());
            }
            for (String clazz : persistenceUnit.getClazz()) {
                TypeDescriptor typeDescriptor = ((TypeResolver)scanner.getContext().peek(TypeResolver.class)).resolve(clazz, scanner.getContext()).getTypeDescriptor();
                persistenceUnitDescriptor.getContains().add(typeDescriptor);
            }
            Persistence.PersistenceUnit.Properties properties = persistenceUnit.getProperties();
            if (properties != null) {
                for (Persistence.PersistenceUnit.Properties.Property property : properties.getProperty()) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
                    propertyDescriptor.setName(property.getName());
                    propertyDescriptor.setValue(property.getValue());
                    persistenceUnitDescriptor.getProperties().add(propertyDescriptor);
                }
            }
            persistenceXmlDescriptor.getContains().add(persistenceUnitDescriptor);
        }
        return persistenceXmlDescriptor;
    }
}

