/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLDocumentDescriptor;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLFileDescriptor;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLKeyBucket;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLKeyDescriptor;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLValueBucket;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLValueDescriptor;
import com.buschmais.jqassistant.plugin.yaml.impl.scanner.ProcessingContext;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

class YAMLEmitter
implements Emitable {
    private final YAMLFileDescriptor fileDescriptor;
    private final Scanner currentScanner;
    private ProcessingContext processingContext = new ProcessingContext();

    public YAMLEmitter(YAMLFileDescriptor yamlFileDescriptor, Scanner scanner) {
        this.fileDescriptor = yamlFileDescriptor;
        this.currentScanner = scanner;
        this.processingContext.push(yamlFileDescriptor);
    }

    public void emit(Event event) throws IOException {
        EventType typeOfEvent = this.toEventType(event);
        if (typeOfEvent != null) {
            switch (typeOfEvent) {
                case DOCUMENT_START: {
                    this.handleDocumentStartEvent(event);
                    break;
                }
                case SEQUENCE_START: {
                    this.handleSequenceStart(event);
                    break;
                }
                case SEQUENCE_END: {
                    this.handleSequenceEnd(event);
                    break;
                }
                case DOCUMENT_END: {
                    this.handleDocumentEndEvent(event);
                    break;
                }
                case MAPPING_START: {
                    this.handleMappingStartEvent(event);
                    break;
                }
                case MAPPING_END: {
                    this.handleMappingEndEvent(event);
                    break;
                }
                case SCALAR: {
                    this.handleScalarEvent((ScalarEvent)event);
                    break;
                }
                default: {
                    YAMLEmitter.unsupportedYAMLStructure(event);
                }
            }
        }
    }

    protected void handleSequenceStart(Event event) {
        if (this.processingContext.isContext(ParseContext.SEQUENCE_CXT)) {
            YAMLValueDescriptor valueDescriptor = (YAMLValueDescriptor)this.currentScanner.getContext().getStore().create(YAMLValueDescriptor.class);
            this.processingContext.push(valueDescriptor);
            this.processingContext.pushContextEvent(ParseContext.SEQUENCE_CXT);
        } else {
            this.processingContext.pushContextEvent(ParseContext.SEQUENCE_CXT);
        }
    }

    protected void handleSequenceEnd(Event event) {
        if (this.processingContext.isContext(ParseContext.MAPPING_CXT, ParseContext.MAPPING_KEY_CXT, ParseContext.SEQUENCE_CXT)) {
            this.processingContext.popContextEvent(2);
            YAMLKeyDescriptor keyForSequence = (YAMLKeyDescriptor)this.processingContext.pop();
            YAMLKeyBucket keyBucketForSequence = (YAMLKeyBucket)this.processingContext.peek();
            keyBucketForSequence.getKeys().add(keyForSequence);
        } else if (this.processingContext.isContext(ParseContext.DOCUMENT_CTX, ParseContext.SEQUENCE_CXT)) {
            this.processingContext.popContextEvent(1);
        } else if (this.processingContext.isContext(ParseContext.SEQUENCE_CXT, ParseContext.SEQUENCE_CXT)) {
            this.processingContext.popContextEvent(1);
            YAMLValueDescriptor value = (YAMLValueDescriptor)this.processingContext.pop();
            YAMLValueBucket bbb = (YAMLValueBucket)this.processingContext.peek();
            bbb.getValues().add(value);
        } else {
            YAMLEmitter.unsupportedYAMLStructure(event);
        }
    }

    protected void handleDocumentEndEvent(Event event) {
        if (!this.processingContext.isContext(ParseContext.DOCUMENT_CTX)) {
            YAMLEmitter.unsupportedYAMLStructure(event);
        } else {
            this.processingContext.popContextEvent(1);
            YAMLDocumentDescriptor doc = (YAMLDocumentDescriptor)this.processingContext.pop();
            this.fileDescriptor.getDocuments().add(doc);
        }
    }

    protected void handleDocumentStartEvent(Event event) {
        YAMLDocumentDescriptor doc = (YAMLDocumentDescriptor)this.currentScanner.getContext().getStore().create(YAMLDocumentDescriptor.class);
        this.processingContext.pushContextEvent(ParseContext.DOCUMENT_CTX);
        this.processingContext.push(doc);
    }

    protected void handleMappingStartEvent(Event event) {
        this.processingContext.pushContextEvent(ParseContext.MAPPING_CXT);
    }

    protected void handleMappingEndEvent(Event event) {
        if (this.processingContext.isContext(ParseContext.MAPPING_CXT, ParseContext.MAPPING_KEY_CXT, ParseContext.MAPPING_CXT)) {
            this.processingContext.popContextEvent(2);
            YAMLKeyDescriptor currentKey = (YAMLKeyDescriptor)this.processingContext.pop();
            YAMLKeyBucket parent = (YAMLKeyBucket)this.processingContext.peek();
            parent.getKeys().add(currentKey);
        } else if (this.processingContext.isContext(ParseContext.MAPPING_CXT)) {
            this.processingContext.popContextEvent(1);
        } else if (this.processingContext.isContext(ParseContext.MAPPING_CXT, ParseContext.MAPPING_KEY_CXT, ParseContext.MAPPING_CXT, ParseContext.MAPPING_KEY_CXT, ParseContext.MAPPING_VALUE_CXT)) {
            this.processingContext.popContextEvent(4);
            YAMLKeyDescriptor currentKey = (YAMLKeyDescriptor)this.processingContext.pop();
            YAMLKeyDescriptor parentKeyOfThis = (YAMLKeyDescriptor)this.processingContext.pop();
            YAMLKeyBucket parent = (YAMLKeyBucket)this.processingContext.peek();
            parentKeyOfThis.getKeys().add(currentKey);
            parent.getKeys().add(parentKeyOfThis);
        } else if (this.processingContext.isContext(ParseContext.MAPPING_CXT, ParseContext.MAPPING_KEY_CXT, ParseContext.MAPPING_VALUE_CXT)) {
            this.processingContext.popContextEvent(3);
            YAMLKeyDescriptor keyDescriptor = (YAMLKeyDescriptor)this.processingContext.pop();
            YAMLKeyBucket bucket = (YAMLKeyBucket)this.processingContext.peek();
            bucket.getKeys().add(keyDescriptor);
        } else {
            YAMLEmitter.unsupportedYAMLStructure(event);
        }
    }

    protected void handleScalarEvent(ScalarEvent event) {
        if (this.processingContext.isContext(ParseContext.MAPPING_CXT)) {
            YAMLKeyDescriptor key = (YAMLKeyDescriptor)this.currentScanner.getContext().getStore().create(YAMLKeyDescriptor.class);
            String name = event.getValue();
            String fqn = this.processingContext.buildNextFQN(name);
            key.setName(StringUtils.trimToEmpty((String)name));
            key.setFullQualifiedName(StringUtils.trimToEmpty((String)fqn));
            this.processingContext.push(key);
            this.processingContext.pushContextEvent(ParseContext.MAPPING_KEY_CXT);
        } else if (this.processingContext.isContext(ParseContext.MAPPING_CXT, ParseContext.MAPPING_KEY_CXT)) {
            YAMLValueDescriptor value = (YAMLValueDescriptor)this.currentScanner.getContext().getStore().create(YAMLValueDescriptor.class);
            String rawValue = event.getValue();
            if (!StringUtils.isBlank((String)rawValue)) {
                value.setValue(rawValue);
                YAMLKeyDescriptor key = (YAMLKeyDescriptor)this.processingContext.peek();
                key.getValues().add(value);
            }
            this.processingContext.pushContextEvent(ParseContext.MAPPING_VALUE_CXT);
        } else if (this.processingContext.isContext(ParseContext.MAPPING_CXT, ParseContext.MAPPING_KEY_CXT, ParseContext.MAPPING_VALUE_CXT)) {
            this.processingContext.popContextEvent(2);
            YAMLKeyDescriptor key = (YAMLKeyDescriptor)this.processingContext.pop();
            YAMLKeyBucket bucket = (YAMLKeyBucket)this.processingContext.peek();
            bucket.getKeys().add(key);
            YAMLKeyDescriptor nextKey = (YAMLKeyDescriptor)this.currentScanner.getContext().getStore().create(YAMLKeyDescriptor.class);
            String name = event.getValue();
            String fqn = this.processingContext.buildNextFQN(name);
            nextKey.setName(StringUtils.trimToEmpty((String)name));
            nextKey.setFullQualifiedName(StringUtils.trimToEmpty((String)fqn));
            this.processingContext.push(nextKey);
            this.processingContext.pushContextEvent(ParseContext.MAPPING_KEY_CXT);
        } else if (this.processingContext.isContext(ParseContext.SEQUENCE_CXT)) {
            YAMLValueDescriptor value = (YAMLValueDescriptor)this.currentScanner.getContext().getStore().create(YAMLValueDescriptor.class);
            String rawValue = event.getValue();
            value.setValue(StringUtils.trimToEmpty((String)rawValue));
            YAMLValueBucket bucket = (YAMLValueBucket)this.processingContext.peek();
            bucket.getValues().add(value);
        } else if (this.processingContext.isContext(ParseContext.DOCUMENT_CTX)) {
            YAMLValueDescriptor value = (YAMLValueDescriptor)this.currentScanner.getContext().getStore().create(YAMLValueDescriptor.class);
            String rawValue = event.getValue();
            value.setValue(StringUtils.trimToEmpty((String)rawValue));
            YAMLValueBucket bucket = (YAMLValueBucket)this.processingContext.peek();
            bucket.getValues().add(value);
        } else {
            YAMLEmitter.unsupportedYAMLStructure((Event)event);
        }
    }

    private EventType toEventType(Event event) {
        EventType result = null;
        if (!(event instanceof StreamEndEvent) && !(event instanceof StreamStartEvent)) {
            if (event instanceof MappingStartEvent) {
                result = EventType.MAPPING_START;
            } else if (event instanceof MappingEndEvent) {
                result = EventType.MAPPING_END;
            } else if (event instanceof DocumentStartEvent) {
                result = EventType.DOCUMENT_START;
            } else if (event instanceof DocumentEndEvent) {
                result = EventType.DOCUMENT_END;
            } else if (event instanceof ScalarEvent) {
                result = EventType.SCALAR;
            } else if (event instanceof SequenceStartEvent) {
                result = EventType.SEQUENCE_START;
            } else if (event instanceof SequenceEndEvent) {
                result = EventType.SEQUENCE_END;
            } else {
                YAMLEmitter.unsupportedYAMLStructure(event);
            }
        }
        return result;
    }

    private static void unsupportedYAMLStructure(Event event) {
        String templ = "Found %s in an unexpected position in the YAML document. This might be an error in the YAML document, a bug in our parser or an unsupported YAML document structure. Please verify the document or submit a bug.";
        throw new RuntimeException(String.format(templ, event.toString()));
    }

    public static enum ParseContext {
        DOCUMENT_CTX,
        MAPPING_CXT,
        MAPPING_KEY_CXT,
        MAPPING_VALUE_CXT,
        SEQUENCE_CXT;

    }

    public static enum EventType {
        DOCUMENT_END,
        DOCUMENT_START,
        MAPPING_END,
        MAPPING_START,
        SCALAR,
        SEQUENCE_END,
        SEQUENCE_START;

    }
}

