/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.ValueAxisLogarithmic;

class Mapper {
    private RrdGraphDef gdef;
    private ImageParameters im;
    private double pixieX;
    private double pixieY;

    Mapper(RrdGraph rrdGraph) {
        this.gdef = rrdGraph.gdef;
        this.im = rrdGraph.im;
        this.pixieX = (double)this.im.xsize / (double)(this.im.end - this.im.start);
        this.pixieY = !this.gdef.logarithmic ? (double)this.im.ysize / (this.im.maxval - this.im.minval) : (double)this.im.ysize / (ValueAxisLogarithmic.log10(this.im.maxval) - ValueAxisLogarithmic.log10(this.im.minval));
    }

    int xtr(double mytime) {
        return (int)((double)this.im.xorigin + this.pixieX * (mytime - (double)this.im.start));
    }

    int ytr(double value) {
        double yval = !this.gdef.logarithmic ? (double)this.im.yorigin - this.pixieY * (value - this.im.minval) + 0.5 : (value < this.im.minval ? (double)this.im.yorigin : (double)this.im.yorigin - this.pixieY * (ValueAxisLogarithmic.log10(value) - ValueAxisLogarithmic.log10(this.im.minval)) + 0.5);
        if (!this.gdef.rigid) {
            return (int)yval;
        }
        if ((int)yval > this.im.yorigin) {
            return this.im.yorigin + 2;
        }
        if ((int)yval < this.im.yorigin - this.im.ysize) {
            return this.im.yorigin - this.im.ysize - 2;
        }
        return (int)yval;
    }
}

