/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.rrd4j.core.jrrd.Constants;
import org.rrd4j.core.jrrd.UnivalArray;

class RRDFile
implements Constants {
    private int alignment;
    private int longSize = 4;
    final RandomAccessFile ras;
    private ByteBuffer bbuffer = ByteBuffer.allocate(1024);
    private byte[] buffer = this.bbuffer.array();
    private ByteOrder order;

    RRDFile(String name) throws IOException {
        this(new File(name));
    }

    RRDFile(File file) throws IOException {
        this.ras = new RandomAccessFile(file, "r");
        this.initDataLayout(file);
    }

    private int read(int len) throws IOException {
        this.bbuffer.clear();
        int read = this.ras.read(this.buffer, 0, len);
        return read;
    }

    private void initDataLayout(File file) throws IOException {
        if (file.exists()) {
            this.read(32);
            int index = this.indexOf(FLOAT_COOKIE_BIG_ENDIAN, this.buffer);
            if (index != -1) {
                this.order = ByteOrder.BIG_ENDIAN;
            } else {
                index = this.indexOf(FLOAT_COOKIE_LITTLE_ENDIAN, this.buffer);
                if (index != -1) {
                    this.order = ByteOrder.LITTLE_ENDIAN;
                } else {
                    throw new IOException("Invalid RRD file");
                }
            }
            this.bbuffer.order(this.order);
            switch (index) {
                case 12: {
                    this.alignment = 4;
                    break;
                }
                case 16: {
                    this.alignment = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported architecture");
                }
            }
            this.bbuffer.position(index + 8);
            int int1 = this.bbuffer.getInt();
            int int2 = this.bbuffer.getInt();
            if (int1 == 0 || int2 == 0) {
                this.longSize = 8;
            }
        }
        this.ras.seek(0L);
    }

    private int indexOf(byte[] pattern, byte[] array) {
        return new String(array).indexOf(new String(pattern));
    }

    boolean isBigEndian() {
        return this.order == ByteOrder.BIG_ENDIAN;
    }

    int getAlignment() {
        return this.alignment;
    }

    double readDouble() throws IOException {
        this.read(8);
        return this.bbuffer.getDouble();
    }

    int readInt() throws IOException {
        this.read(4);
        return this.bbuffer.getInt();
    }

    int readLong() throws IOException {
        this.read(this.longSize);
        if (this.longSize == 4) {
            return this.bbuffer.getInt();
        }
        return (int)this.bbuffer.getLong();
    }

    String readString(int maxLength) throws IOException {
        this.ras.read(this.buffer, 0, maxLength);
        return new String(this.buffer, 0, maxLength).trim();
    }

    void skipBytes(int n) throws IOException {
        this.ras.skipBytes(n);
    }

    int align(int boundary) throws IOException {
        int skip = (int)((long)boundary - this.ras.getFilePointer() % (long)boundary) % boundary;
        if (skip != 0) {
            this.ras.skipBytes(skip);
        }
        return skip;
    }

    int align() throws IOException {
        return this.align(this.alignment);
    }

    long info() throws IOException {
        return this.ras.getFilePointer();
    }

    long getFilePointer() throws IOException {
        return this.ras.getFilePointer();
    }

    void close() throws IOException {
        this.ras.close();
    }

    void read(ByteBuffer bb) throws IOException {
        this.ras.getChannel().read(bb);
    }

    UnivalArray getUnivalArray(int size) throws IOException {
        return new UnivalArray(this, size);
    }

    int getBits() {
        return this.longSize * 8;
    }
}

