/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDbPool;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.Util;

class RrdDbPoolNew
extends RrdDbPool {
    private Semaphore capacity;
    private int maxCapacity = 200;
    private final Map<String, RrdEntry> pool = new HashMap<String, RrdEntry>(200);
    private final Semaphore poolLock = new Semaphore(1, true);

    protected RrdDbPoolNew() {
        if (!(RrdBackendFactory.getDefaultFactory() instanceof RrdFileBackendFactory)) {
            throw new RuntimeException("Cannot create instance of " + this.getClass().getName() + " with " + "a default backend factory not derived from RrdFileBackendFactory");
        }
        this.capacity = new Semaphore(this.maxCapacity, true){

            @Override
            public String toString() {
                return "Capacity semaphore: " + super.toString();
            }
        };
    }

    @Override
    public int getOpenFileCount() {
        return this.maxCapacity - this.capacity.availablePermits();
    }

    @Override
    public String[] getOpenFiles() {
        try {
            this.poolLock.acquire();
            HashSet<String> files = new HashSet<String>(this.pool.keySet().size());
            for (Map.Entry<String, RrdEntry> e : this.pool.entrySet()) {
                RrdEntry re = e.getValue();
                if (re == null || re.count.get() <= 0) continue;
                files.add(e.getKey());
            }
            this.poolLock.release();
            return files.toArray(new String[files.size()]);
        }
        catch (InterruptedException interruptedException) {
            return new String[0];
        }
    }

    private RrdEntry getEntry(String path) throws IOException {
        RrdEntry ref;
        String canonicalPath = Util.getCanonicalPath(path);
        boolean poollocked = false;
        try {
            this.poolLock.acquire();
            poollocked = true;
            ref = this.pool.get(canonicalPath);
            if (ref == null) {
                ref = new RrdEntry();
                this.pool.put(canonicalPath, ref);
            }
            ref.rlock.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (poollocked) {
                this.poolLock.release();
            }
        }
        return ref;
    }

    private RrdEntry getUnusedEntry(String path) throws IOException {
        String canonicalPath = Util.getCanonicalPath(path);
        RrdEntry ref = this.getEntry(canonicalPath);
        ref.rlock.release();
        do {
            try {
                ref.ulock.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("RrdDb acquire interrupted", e);
            }
            ref = this.getEntry(canonicalPath);
        } while (ref.count.get() != 0);
        try {
            this.capacity.acquire();
        }
        catch (InterruptedException e) {
            ref.rlock.release();
            ref.ulock.release();
            throw new RuntimeException("RrdDb acquire interrupted", e);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(RrdDb rrdDb) throws IOException {
        if (rrdDb == null) {
            return;
        }
        String canonicalPath = rrdDb.getCanonicalPath();
        RrdEntry ref = this.getEntry(canonicalPath);
        try {
            if (ref.count.get() <= 0) {
                throw new IllegalStateException("Could not release [" + canonicalPath + "], the file was never requested");
            }
            if (ref.count.decrementAndGet() <= 0 && ref.rrdDb != null) {
                ref.rrdDb.close();
                ref.rrdDb = null;
                this.capacity.release();
                ref.count.set(0);
                ref.ulock.release();
            }
        }
        finally {
            ref.rlock.release();
        }
        boolean poollocked = false;
        if (ref.count.get() == 0) {
            try {
                this.poolLock.acquire();
                poollocked = true;
                ref = this.pool.get(canonicalPath);
                if (ref != null && ref.rlock.tryAcquire()) {
                    if (ref.count.get() == 0) {
                        this.pool.remove(canonicalPath);
                    }
                    ref.rlock.release();
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                if (poollocked) {
                    this.poolLock.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RrdDb requestRrdDb(String path) throws IOException {
        RrdEntry ref;
        block8: {
            ref = this.getEntry(path);
            try {
                if (ref.count.get() > 0) {
                    ref.count.incrementAndGet();
                    break block8;
                }
                try {
                    this.capacity.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("RrdDb acquire interrupted", e);
                }
                try {
                    ref.rrdDb = new RrdDb(path);
                }
                catch (IOException e) {
                    this.capacity.release();
                    throw e;
                }
                ref.count.set(1);
                ref.ulock.tryAcquire();
            }
            finally {
                ref.rlock.release();
            }
        }
        return ref.rrdDb;
    }

    @Override
    public RrdDb requestRrdDb(RrdDef rrdDef) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.getUnusedEntry(rrdDef.getPath());
            ref.rrdDb = new RrdDb(rrdDef);
            ref.count.set(1);
        }
        catch (IOException e) {
            this.capacity.release();
            throw e;
        }
        catch (IllegalArgumentException e) {
            this.capacity.release();
            throw e;
        }
        finally {
            ref.rlock.release();
        }
        return ref.rrdDb;
    }

    @Override
    public RrdDb requestRrdDb(String path, String sourcePath) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.getUnusedEntry(path);
            ref.rrdDb = new RrdDb(path, sourcePath);
            ref.count.set(1);
        }
        catch (IOException e) {
            this.capacity.release();
            throw e;
        }
        finally {
            ref.rlock.release();
        }
        return ref.rrdDb;
    }

    @Override
    public void setCapacity(int newCapacity) {
        int available = this.capacity.drainPermits();
        if (available != this.maxCapacity) {
            this.capacity.release(available);
            throw new RuntimeException("Can only be done on a empty pool");
        }
        this.capacity = new Semaphore(newCapacity, true){

            @Override
            public String toString() {
                return "Capacity semaphore: " + super.toString();
            }
        };
        this.maxCapacity = newCapacity;
    }

    @Override
    public int getCapacity() {
        return this.maxCapacity;
    }

    @Override
    public int getOpenCount(RrdDb rrdDb) throws IOException {
        String canonicalPath = rrdDb.getCanonicalPath();
        RrdEntry ref = this.pool.get(canonicalPath);
        if (ref == null) {
            return 0;
        }
        return ref.count.get();
    }

    @Override
    public int getOpenCount(String path) throws IOException {
        String canonicalPath = Util.getCanonicalPath(path);
        RrdEntry ref = this.pool.get(canonicalPath);
        if (ref == null) {
            return 0;
        }
        return ref.count.get();
    }

    private static class RrdEntry {
        volatile RrdDb rrdDb = null;
        final AtomicInteger count = new AtomicInteger(0);
        final Semaphore ulock = new Semaphore(1, true);
        final Semaphore rlock = new Semaphore(1, true);

        private RrdEntry() {
        }
    }
}

