/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.scanner.impl;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.Store;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ScannerContextImpl
implements ScannerContext {
    private final Store store;
    private final Map<Class<?>, Deque<?>> contextValuesPerKey = new HashMap();

    public ScannerContextImpl(Store store) {
        this.store = store;
    }

    @Override
    public <T> void push(Class<T> key, T value) {
        this.getValues(key).push(value);
    }

    @Override
    public <T> T peek(Class<T> key) {
        T value = this.getValues(key).peek();
        if (value == null) {
            throw new IllegalStateException("Cannot find a value for '" + key.getName() + "' in the context");
        }
        return value;
    }

    @Override
    public <T> T peekOrDefault(Class<T> key, T defaultValue) {
        T value = this.getValues(key).peek();
        return value != null ? value : defaultValue;
    }

    @Override
    public <T> T pop(Class<T> key) {
        return this.getValues(key).pop();
    }

    <T> Deque<T> getValues(Class<T> key) {
        Deque<?> values = this.contextValuesPerKey.get(key);
        if (values == null) {
            values = new LinkedList();
            this.contextValuesPerKey.put(key, values);
        }
        return values;
    }

    @Override
    public Store getStore() {
        return this.store;
    }
}

