/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.xml.api.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLFileFilter {
    private static XMLInputFactory factory;
    private static final Logger LOGGER;

    private XMLFileFilter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean rootElementMatches(FileResource fileResource, String path, String expectedRootElement) throws IOException {
        try (InputStream stream = fileResource.createStream();){
            XMLStreamReader reader = factory.createXMLStreamReader(stream);
            if (!reader.hasNext()) return false;
            int event = reader.next();
            switch (event) {
                case 1: {
                    String rootElement = reader.getLocalName();
                    boolean bl = expectedRootElement.equals(rootElement);
                    return bl;
                }
            }
            return false;
        }
        catch (XMLStreamException e) {
            LOGGER.warn("Cannot parse XML file '{}'.", (Object)path);
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(XMLFileFilter.class);
        factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
    }
}

