/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.xml.api.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class JAXBUnmarshaller<X> {
    private Class<X> rootElementType;
    private Map<String, String> namespaceMapping;
    private XMLInputFactory inputFactory;
    private JAXBContext jaxbContext;

    public JAXBUnmarshaller(Class<X> rootElementType) {
        this(rootElementType, Collections.emptyMap());
    }

    public JAXBUnmarshaller(Class<X> rootElementType, Map<String, String> namespaceMapping) {
        this.rootElementType = rootElementType;
        this.namespaceMapping = namespaceMapping;
        this.inputFactory = XMLInputFactory.newInstance();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{rootElementType});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context for " + rootElementType.getName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X unmarshal(FileResource item) throws IOException {
        try (InputStream stream = item.createStream();){
            NamespaceMappingStreamReader xmlStreamReader = new NamespaceMappingStreamReader(this.inputFactory.createXMLStreamReader(stream), this.namespaceMapping);
            X x = this.unmarshal(xmlStreamReader);
            return x;
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot read XML document.", e);
        }
    }

    private X unmarshal(XMLStreamReader xmlStreamReader) throws IOException {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            return (X)unmarshaller.unmarshal(xmlStreamReader, this.rootElementType).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot unmarshal XML document.", e);
        }
    }

    private static class NamespaceMappingStreamReader
    extends StreamReaderDelegate {
        private Map<String, String> namespaceMapping;

        public NamespaceMappingStreamReader(XMLStreamReader reader, Map<String, String> namespaceMapping) {
            super(reader);
            this.namespaceMapping = namespaceMapping;
        }

        @Override
        public String getAttributeNamespace(int index) {
            return this.map(super.getAttributeNamespace(index));
        }

        @Override
        public String getNamespaceURI() {
            return this.map(super.getNamespaceURI());
        }

        private String map(String documentNamespace) {
            String namespace = this.namespaceMapping.get(documentNamespace);
            return namespace != null ? namespace : documentNamespace;
        }
    }
}

