/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.junit.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.junit.api.model.TestCaseDescriptor;
import com.buschmais.jqassistant.plugin.junit.api.model.TestSuiteDescriptor;
import com.buschmais.jqassistant.plugin.junit.api.scanner.JunitScope;
import com.buschmais.jqassistant.plugin.xml.api.scanner.AbstractXmlFileScannerPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class TestReportScannerPlugin
extends AbstractXmlFileScannerPlugin<TestSuiteDescriptor> {
    private final NumberFormat timeFormat = NumberFormat.getInstance(Locale.US);
    private XMLInputFactory inputFactory;

    public void initialize() {
        this.inputFactory = XMLInputFactory.newInstance();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return JunitScope.TESTREPORTS.equals(scope) && path.matches(".*TEST-.*\\.xml");
    }

    public TestSuiteDescriptor scan(FileResource item, TestSuiteDescriptor testSuiteDescriptor, String path, Scope scope, Scanner scanner) throws IOException {
        try (InputStream stream = item.createStream();){
            XMLEventReader reader = this.inputFactory.createXMLEventReader(stream);
            TestCaseDescriptor testCaseDescriptor = null;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement element = event.asStartElement();
                String elementName = element.getName().getLocalPart();
                Iterator<Attribute> attributes = element.getAttributes();
                switch (elementName) {
                    case "testsuite": {
                        String value;
                        String attributeName;
                        Attribute attribute;
                        while (attributes.hasNext()) {
                            attribute = attributes.next();
                            attributeName = attribute.getName().getLocalPart();
                            value = attribute.getValue();
                            switch (attributeName) {
                                case "name": {
                                    testSuiteDescriptor.setName(value);
                                    break;
                                }
                                case "time": {
                                    testSuiteDescriptor.setTime(this.parseTime(value));
                                    break;
                                }
                                case "tests": {
                                    testSuiteDescriptor.setTests(Integer.parseInt(value));
                                    break;
                                }
                                case "failures": {
                                    testSuiteDescriptor.setFailures(Integer.parseInt(value));
                                    break;
                                }
                                case "errors": {
                                    testSuiteDescriptor.setErrors(Integer.parseInt(value));
                                    break;
                                }
                                case "skipped": {
                                    testSuiteDescriptor.setSkipped(Integer.parseInt(value));
                                }
                            }
                        }
                        break;
                    }
                    case "testcase": {
                        String value;
                        String attributeName;
                        Attribute attribute;
                        testCaseDescriptor = (TestCaseDescriptor)scanner.getContext().getStore().create(TestCaseDescriptor.class);
                        testCaseDescriptor.setResult(TestCaseDescriptor.Result.SUCCESS);
                        testSuiteDescriptor.getTestCases().add(testCaseDescriptor);
                        while (attributes.hasNext()) {
                            attribute = attributes.next();
                            attributeName = attribute.getName().getLocalPart();
                            value = attribute.getValue();
                            switch (attributeName) {
                                case "name": {
                                    testCaseDescriptor.setName(value);
                                    break;
                                }
                                case "time": {
                                    testCaseDescriptor.setTime(this.parseTime(value));
                                    break;
                                }
                                case "classname": {
                                    testCaseDescriptor.setClassName(value);
                                }
                            }
                        }
                        break;
                    }
                    case "failure": {
                        testCaseDescriptor.setResult(TestCaseDescriptor.Result.FAILURE);
                        break;
                    }
                    case "error": {
                        testCaseDescriptor.setResult(TestCaseDescriptor.Result.ERROR);
                        break;
                    }
                    case "skipped": {
                        testCaseDescriptor.setResult(TestCaseDescriptor.Result.SKIPPED);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot read XML document.", e);
        }
        return testSuiteDescriptor;
    }

    private float parseTime(String value) throws IOException {
        try {
            return this.timeFormat.parse(value).floatValue();
        }
        catch (ParseException e) {
            throw new IOException("Cannot parse time.", e);
        }
    }
}

