/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.bootstrap.osgi;

import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.api.bootstrap.XOUnitBuilder;
import com.buschmais.xo.api.bootstrap.XOUnitParameter;
import com.buschmais.xo.spi.reflection.ClassHelper;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.osgi.service.cm.ConfigurationException;

public final class XOUnitConverter {
    private XOUnitConverter() {
    }

    public static XOUnit fromProperties(Dictionary<String, ?> properties) throws ConfigurationException {
        XOUnitBuilder builder;
        String url = (String)properties.get(XOUnitParameter.URL.getKey());
        if (url == null) {
            throw new ConfigurationException(XOUnitParameter.URL.getKey(), "Property missing");
        }
        Collection typeNames = (Collection)properties.get(XOUnitParameter.TYPES.getKey());
        if (typeNames == null) {
            throw new ConfigurationException(XOUnitParameter.TYPES.getKey(), "Property missing");
        }
        Collection types = ClassHelper.getTypes((Collection)typeNames);
        String providerName = (String)properties.get(XOUnitParameter.PROVIDER.getKey());
        if (providerName == null) {
            throw new ConfigurationException(XOUnitParameter.PROVIDER.getKey(), "Property missing");
        }
        Class provider = ClassHelper.getType((String)providerName);
        try {
            builder = XOUnitBuilder.create((String)url, (Class)provider, (Class[])types.toArray(new Class[0]));
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(XOUnitParameter.URL.getKey(), "Could not convert '" + url + "' to url", (Throwable)e);
        }
        String name = (String)properties.get(XOUnitParameter.NAME.getKey());
        builder.name(name);
        String description = (String)properties.get(XOUnitParameter.DESCRIPTION.getKey());
        builder.description(description);
        Collection listenerNames = (Collection)properties.get(XOUnitParameter.INSTANCE_LISTENERS.getKey());
        if (listenerNames != null) {
            Collection instanceListeners = ClassHelper.getTypes((Collection)listenerNames);
            builder.instanceListenerTypes(instanceListeners.toArray(new Class[0]));
        }
        String concurrencyMode = (String)properties.get(XOUnitParameter.CONCURRENCY_MODE.getKey());
        builder.concurrencyMode(concurrencyMode);
        String validationMode = (String)properties.get(XOUnitParameter.VALIDATION_MODE.getKey());
        builder.validationMode(validationMode);
        String transactionMode = (String)properties.get(XOUnitParameter.TRANSACTION_ATTRIBUTE.getKey());
        builder.transactionAttribute(transactionMode);
        Collection entries = (Collection)properties.get(XOUnitParameter.PROPERTIES.getKey());
        if (entries != null) {
            Properties providerProps = XOUnitConverter.toMap(entries);
            builder.properties(providerProps);
        }
        return builder.create();
    }

    public static Properties fromXOUnit(XOUnit xoUnit) {
        Properties properties = new Properties();
        Properties props = xoUnit.getProperties();
        Collection<Object> providerProps = XOUnitConverter.toList(props);
        if (!providerProps.isEmpty()) {
            properties.put(XOUnitParameter.PROPERTIES.getKey(), providerProps);
        }
        return properties;
    }

    private static Properties toMap(Collection<Object> entries) throws ConfigurationException {
        Properties properties = new Properties();
        if (entries.size() % 2 == 0) {
            Iterator<Object> it = entries.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = it.next();
                properties.put(key, value);
            }
        } else {
            throw new ConfigurationException(XOUnitParameter.PROPERTIES.getKey(), "");
        }
        return properties;
    }

    private static Collection<Object> toList(Properties props) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            entries.add(entry.getKey());
            entries.add(entry.getValue());
        }
        return entries;
    }
}

