/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.bootstrap.osgi;

import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.impl.XOManagerFactoryImpl;
import com.buschmais.xo.impl.bootstrap.XOUnitFactory;
import com.buschmais.xo.impl.bootstrap.osgi.XOManagerFactoryServiceFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XOUnitBundleListener
implements BundleActivator,
BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(XOUnitBundleListener.class);
    private final Map<Long, List<XOManagerFactory>> registeredXOManagerFactories = new HashMap<Long, List<XOManagerFactory>>();
    private ServiceRegistration<ManagedServiceFactory> serviceFactoryRegistration;
    private XOManagerFactoryServiceFactory serviceFactory;

    public void start(BundleContext context) throws Exception {
        context.addBundleListener((BundleListener)this);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "com.buschmais.xo.factory");
        this.serviceFactory = new XOManagerFactoryServiceFactory(context);
        this.serviceFactoryRegistration = context.registerService(ManagedServiceFactory.class, (Object)this.serviceFactory, props);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ConfigAdmin listener registered");
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        this.serviceFactory.stop();
        if (this.serviceFactoryRegistration != null) {
            this.serviceFactoryRegistration.unregister();
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.deployXOUnits(event.getBundle());
                break;
            }
            case 4: {
                this.undeployXOUnits(event.getBundle());
                break;
            }
        }
    }

    private void deployXOUnits(Bundle bundle) {
        Enumeration e = bundle.findEntries("META-INF", "xo.xml", false);
        if (e != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Deploying XO units in bundle '{}'", (Object)bundle.getSymbolicName());
            }
            LinkedList xoManagerFactories = new LinkedList();
            while (e.hasMoreElements()) {
                List<Object> xoUnits;
                block7: {
                    URL xoUnitUrl = (URL)e.nextElement();
                    xoUnits = Collections.emptyList();
                    try {
                        xoUnits = XOUnitFactory.getInstance().getXOUnits(xoUnitUrl);
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isErrorEnabled()) break block7;
                        LOGGER.error("Error while loading XOUnit", (Throwable)ioe);
                    }
                }
                for (XOUnit xOUnit : xoUnits) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Found XOUnit '{}'", (Object)xOUnit.getName());
                    }
                    XOManagerFactoryImpl xoManagerFactory = new XOManagerFactoryImpl(xOUnit);
                    Hashtable<String, String> p = new Hashtable<String, String>();
                    ((Dictionary)p).put("name", xOUnit.getName());
                    bundle.getBundleContext().registerService(XOManagerFactory.class, xoManagerFactory, p);
                    xoManagerFactories.add(xoManagerFactory);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Registered service for XOUnit '{}'", (Object)xOUnit.getName());
                }
            }
            this.registeredXOManagerFactories.put(bundle.getBundleId(), xoManagerFactories);
        }
    }

    private void undeployXOUnits(Bundle bundle) {
        List<XOManagerFactory> xoManagerFactories = this.registeredXOManagerFactories.remove(bundle.getBundleId());
        if (xoManagerFactories != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Closing XOManagerFactory for bundle '{}'.", (Object)bundle.getSymbolicName());
            }
            for (XOManagerFactory xoManagerFactory : xoManagerFactories) {
                this.closeXOManagerFactory(xoManagerFactory);
            }
        }
    }

    private void closeXOManagerFactory(XOManagerFactory xoManagerFactory) {
        if (xoManagerFactory != null) {
            xoManagerFactory.close();
        }
    }
}

