/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.impl.datastore.AbstractNeo4jPropertyManager;
import com.buschmais.xo.neo4j.impl.datastore.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.RelationshipMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.RelationshipType;
import com.buschmais.xo.spi.datastore.DatastoreRelationManager;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.type.RelationTypeMetadata;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class Neo4jRelationManager
extends AbstractNeo4jPropertyManager<Relationship>
implements DatastoreRelationManager<Node, Long, Relationship, RelationshipMetadata, RelationshipType, PropertyMetadata> {
    private final GraphDatabaseService graphDatabaseService;

    public Neo4jRelationManager(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public boolean isRelation(Object o) {
        return Relationship.class.isAssignableFrom(o.getClass());
    }

    public RelationshipType getRelationDiscriminator(Relationship relationship) {
        return new RelationshipType(relationship.getType());
    }

    public Relationship createRelation(Node source, RelationTypeMetadata<RelationshipMetadata> metadata, RelationTypeMetadata.Direction direction, Node target, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        Relationship relationship;
        switch (direction) {
            case FROM: {
                relationship = source.createRelationshipTo(target, (org.neo4j.graphdb.RelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator());
                break;
            }
            case TO: {
                relationship = target.createRelationshipTo(source, (org.neo4j.graphdb.RelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator());
                break;
            }
            default: {
                throw new XOException("Unsupported direction " + direction);
            }
        }
        this.setProperties(relationship, example);
        return relationship;
    }

    public void deleteRelation(Relationship relationship) {
        relationship.delete();
    }

    public Long getRelationId(Relationship relationship) {
        return relationship.getId();
    }

    public Relationship findRelationById(RelationTypeMetadata<RelationshipMetadata> metadata, Long id) {
        return this.graphDatabaseService.getRelationshipById(id.longValue());
    }

    public void flushRelation(Relationship relationship) {
    }

    public boolean hasSingleRelation(Node source, RelationTypeMetadata<RelationshipMetadata> metadata, RelationTypeMetadata.Direction direction) {
        return source.hasRelationship((org.neo4j.graphdb.RelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator(), this.getDirection(direction));
    }

    public Relationship getSingleRelation(Node source, RelationTypeMetadata<RelationshipMetadata> metadata, RelationTypeMetadata.Direction direction) {
        return source.getSingleRelationship((org.neo4j.graphdb.RelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator(), this.getDirection(direction));
    }

    public Iterable<Relationship> getRelations(Node source, RelationTypeMetadata<RelationshipMetadata> metadata, RelationTypeMetadata.Direction direction) {
        return source.getRelationships((org.neo4j.graphdb.RelationshipType)((RelationshipMetadata)metadata.getDatastoreMetadata()).getDiscriminator(), this.getDirection(direction));
    }

    public Node getFrom(Relationship relationship) {
        return relationship.getStartNode();
    }

    public Node getTo(Relationship relationship) {
        return relationship.getEndNode();
    }

    private Direction getDirection(RelationTypeMetadata.Direction direction) {
        switch (direction) {
            case FROM: {
                return Direction.OUTGOING;
            }
            case TO: {
                return Direction.INCOMING;
            }
        }
        throw new XOException("Unsupported direction " + direction);
    }
}

