/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.Neo4jDatastoreSession;
import com.buschmais.xo.neo4j.api.TypedNeo4jRepository;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.impl.datastore.Neo4jEntityManager;
import com.buschmais.xo.neo4j.impl.datastore.Neo4jRelationManager;
import com.buschmais.xo.neo4j.impl.datastore.Neo4jRepositoryImpl;
import com.buschmais.xo.neo4j.impl.datastore.TypedNeoj4RepositoryImpl;
import com.buschmais.xo.neo4j.impl.datastore.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.RelationshipMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.RelationshipType;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import com.buschmais.xo.spi.datastore.DatastoreRelationManager;
import com.buschmais.xo.spi.reflection.ClassHelper;
import com.buschmais.xo.spi.session.XOSession;
import java.lang.annotation.Annotation;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public abstract class AbstractNeo4jDatastoreSession<GDS extends GraphDatabaseService>
implements Neo4jDatastoreSession<GDS> {
    private final GDS graphDatabaseService;
    private final Neo4jEntityManager entityManager;
    private final Neo4jRelationManager relationManager;

    public AbstractNeo4jDatastoreSession(GDS graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
        this.entityManager = new Neo4jEntityManager((GraphDatabaseService)graphDatabaseService);
        this.relationManager = new Neo4jRelationManager((GraphDatabaseService)graphDatabaseService);
    }

    public DatastoreEntityManager<Long, Node, NodeMetadata, Label, PropertyMetadata> getDatastoreEntityManager() {
        return this.entityManager;
    }

    public DatastoreRelationManager<Node, Long, Relationship, RelationshipMetadata, RelationshipType, PropertyMetadata> getDatastoreRelationManager() {
        return this.relationManager;
    }

    public Class<? extends Annotation> getDefaultQueryLanguage() {
        return Cypher.class;
    }

    @Override
    public GDS getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    public <R> R createRepository(XOSession xoSession, Class<R> type) {
        if (TypedNeo4jRepository.class.isAssignableFrom(type)) {
            Class typeParameter = ClassHelper.getTypeParameter(TypedNeo4jRepository.class, type);
            if (typeParameter == null) {
                throw new XOException("Cannot determine type parameter for " + type.getName());
            }
            return (R)new TypedNeoj4RepositoryImpl(typeParameter, (GraphDatabaseService)this.graphDatabaseService, (XOSession<Long, Node, NodeMetadata, Label, Long, Relationship, RelationshipMetadata, RelationshipType, PropertyMetadata>)xoSession);
        }
        return (R)new Neo4jRepositoryImpl((GraphDatabaseService)this.graphDatabaseService, (XOSession<Long, Node, NodeMetadata, Label, Long, Relationship, RelationshipMetadata, RelationshipType, PropertyMetadata>)xoSession);
    }

    public void close() {
    }
}

