/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.api;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.neo4j.api.DatastoreFactory;
import com.buschmais.xo.spi.bootstrap.XODatastoreProvider;
import com.buschmais.xo.spi.datastore.Datastore;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jXOProvider
implements XODatastoreProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jXOProvider.class);

    public Datastore<?, ?, ?, ?, ?> createDatastore(XOUnit xoUnit) {
        URI uri = xoUnit.getUri();
        DatastoreFactory datastoreFactory = this.lookupFactory(uri);
        try {
            return datastoreFactory.createGraphDatabaseService(uri, xoUnit.getProperties());
        }
        catch (MalformedURLException e) {
            throw new XOException("Cannot create datastore.", (Throwable)e);
        }
    }

    DatastoreFactory lookupFactory(URI uri) {
        String factoryClass = this.getFactoryClassName(uri);
        LOG.debug("try to lookup provider-class {}", (Object)factoryClass);
        try {
            return (DatastoreFactory)Class.forName(factoryClass).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new XOException("Cannot create datastore factory.", (Throwable)e);
        }
    }

    private String getFactoryClassName(URI uri) {
        String protocol = WordUtils.capitalize((String)uri.getScheme());
        return DatastoreFactory.class.getPackage().getName() + "." + protocol + "DatastoreFactory";
    }
}

