/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileContainerDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.ContainerFileResolver;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainerScannerPlugin<I, E, D extends FileContainerDescriptor>
extends AbstractResourceScannerPlugin<I, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractContainerScannerPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final D scan(I container, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        D containerDescriptor = this.getContainerDescriptor(container, context);
        String containerPath = this.getContainerPath(container, path);
        containerDescriptor.setFileName(containerPath);
        LOGGER.info("Entering {}", (Object)containerPath);
        ContainerFileResolver fileResolverStrategy = new ContainerFileResolver((FileContainerDescriptor)containerDescriptor);
        context.push(FileResolver.class, (Object)fileResolverStrategy);
        this.enterContainer(container, containerDescriptor, scanner.getContext());
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Iterable<E> entries = this.getEntries(container);
            for (E entry : entries) {
                String relativePath = this.getRelativePath(container, entry);
                Resource resource = this.getEntry(container, entry);
                Throwable throwable = null;
                try {
                    LOGGER.debug("Scanning {}", (Object)relativePath);
                    FileDescriptor descriptor = (FileDescriptor)scanner.scan((Object)resource, relativePath, scope);
                    fileResolverStrategy.put(relativePath, descriptor);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
        }
        finally {
            this.leaveContainer(container, containerDescriptor, scanner.getContext());
            context.pop(FileResolver.class);
        }
        fileResolverStrategy.flush();
        LOGGER.info("Leaving {} ({} entries, {} ms)", new Object[]{containerPath, fileResolverStrategy.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return containerDescriptor;
    }

    protected abstract D getContainerDescriptor(I var1, ScannerContext var2);

    protected abstract Iterable<? extends E> getEntries(I var1) throws IOException;

    protected abstract String getContainerPath(I var1, String var2);

    protected abstract String getRelativePath(I var1, E var2);

    protected abstract void enterContainer(I var1, D var2, ScannerContext var3) throws IOException;

    protected abstract void leaveContainer(I var1, D var2, ScannerContext var3) throws IOException;

    protected abstract Resource getEntry(I var1, E var2);
}

