/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl.rest;

import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.AbstractJQARestService;
import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/analysis")
public class AnalysisService
extends AbstractJQARestService {
    private static final String JSON_OBJECT_KEY_CONCEPTS = "concepts";
    private static final String JSON_OBJECT_KEY_ID = "id";
    private static final String JSON_OBJECT_KEY_DESCRIPTION = "description";
    private static final String JSON_OBJECT_KEY_CYPHER = "cypher";
    private static final String JSON_OBJECT_KEY_CONSTRAINTS = "constraints";
    private static final String JSON_OBJECT_KEY_GROUPS = "groups";

    public AnalysisService(@Context Store store) throws PluginRepositoryException, RuleException {
        super(store);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/rules")
    public Response getRuleSet() {
        try {
            JSONObject jsonResponse = this.createJsonResponse(this.getAvailableRules());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonResponse.toString()).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    public String getSomething() {
        return "something";
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/concept")
    public Response runConcept(String conceptId) {
        try {
            InMemoryReportWriter report = this.analyze(Arrays.asList(conceptId), Collections.emptyList(), Collections.emptyList());
            Result conceptResult = (Result)report.getConceptResults().get(conceptId);
            if (conceptResult == null) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
            int effectedRows = conceptResult.getRows().size();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Integer.toString(effectedRows)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/constraint")
    public Response runConstraint(String constraintId) {
        try {
            InMemoryReportWriter report = this.analyze(Collections.emptyList(), Arrays.asList(constraintId), Collections.emptyList());
            int effectedRows = ((Result)report.getConstraintResults().get(constraintId)).getRows().size();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Integer.toString(effectedRows)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/group")
    public Response runGroup(String groupId) {
        try {
            InMemoryReportWriter report = this.analyze(Collections.emptyList(), Collections.emptyList(), Arrays.asList(groupId));
            int effectedRows = 0;
            for (Result conceptResult : report.getConceptResults().values()) {
                effectedRows += conceptResult.getRows().size();
            }
            for (Result constraintResult : report.getConstraintResults().values()) {
                effectedRows += constraintResult.getRows().size();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Integer.toString(effectedRows)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private JSONObject createJsonResponse(RuleSet ruleSet) throws JSONException {
        JSONObject response = new JSONObject();
        JSONArray concepts = new JSONArray();
        response.put(JSON_OBJECT_KEY_CONCEPTS, (Object)concepts);
        for (Object concept : ruleSet.getConceptBucket().getAll()) {
            JSONObject conceptObject = new JSONObject();
            conceptObject.put(JSON_OBJECT_KEY_ID, (Object)concept.getId());
            conceptObject.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)concept.getDescription());
            conceptObject.put(JSON_OBJECT_KEY_CYPHER, (Object)this.getCypher((ExecutableRule)concept));
            concepts.put((Object)conceptObject);
        }
        JSONArray constraints = new JSONArray();
        response.put(JSON_OBJECT_KEY_CONSTRAINTS, (Object)constraints);
        for (Constraint constraint : ruleSet.getConstraintBucket().getAll()) {
            JSONObject constraintObject = new JSONObject();
            constraintObject.put(JSON_OBJECT_KEY_ID, (Object)constraint.getId());
            constraintObject.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)constraint.getDescription());
            constraintObject.put(JSON_OBJECT_KEY_CYPHER, (Object)this.getCypher((ExecutableRule)constraint));
            constraints.put((Object)constraintObject);
        }
        JSONArray groups = new JSONArray();
        response.put(JSON_OBJECT_KEY_GROUPS, (Object)groups);
        for (Group group : ruleSet.getGroupsBucket().getAll()) {
            JSONObject groupObject = new JSONObject();
            groupObject.put(JSON_OBJECT_KEY_ID, (Object)group.getId());
            groupObject.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)group.getDescription());
            groups.put((Object)groupObject);
        }
        return response;
    }

    private String getCypher(ExecutableRule executableRule) {
        Executable executable = executableRule.getExecutable();
        if (executable instanceof CypherExecutable) {
            return ((CypherExecutable)executable).getStatement();
        }
        return null;
    }
}

