/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.report.api.LanguageElement;
import com.buschmais.jqassistant.core.report.api.LanguageHelper;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlReportWriter
implements AnalysisListener<AnalysisListenerException> {
    public static final String NAMESPACE_URL = "http://www.buschmais.com/jqassistant/core/report/schema/v1.0";
    public static final String NAMESPACE_PREFIX = "jqa-report";
    private XMLStreamWriter xmlStreamWriter;
    private Result<? extends ExecutableRule> result;
    private long groupBeginTime;
    private long ruleBeginTime;
    private static final DateFormat XML_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public XmlReportWriter(Writer writer) throws AnalysisListenerException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            this.xmlStreamWriter = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        }
        catch (XMLStreamException e) {
            throw new AnalysisListenerException("Cannot create XML stream writer.", (Throwable)e);
        }
    }

    public void begin() throws AnalysisListenerException {
        this.run(new XmlOperation(){

            @Override
            public void run() throws XMLStreamException {
                XmlReportWriter.this.xmlStreamWriter.writeStartDocument();
                XmlReportWriter.this.xmlStreamWriter.setPrefix(XmlReportWriter.NAMESPACE_PREFIX, XmlReportWriter.NAMESPACE_URL);
                XmlReportWriter.this.xmlStreamWriter.writeStartElement(XmlReportWriter.NAMESPACE_URL, "jqassistant-report");
                XmlReportWriter.this.xmlStreamWriter.writeNamespace(XmlReportWriter.NAMESPACE_PREFIX, XmlReportWriter.NAMESPACE_URL);
            }
        });
    }

    public void end() throws AnalysisListenerException {
        this.run(new XmlOperation(){

            @Override
            public void run() throws XMLStreamException {
                XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                XmlReportWriter.this.xmlStreamWriter.writeEndDocument();
            }
        });
        try {
            this.xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            throw new AnalysisListenerException("Cannot close XML stream writer", (Throwable)e);
        }
    }

    public void beginConcept(Concept concept) throws AnalysisListenerException {
        this.beginExecutable();
    }

    public void endConcept() throws AnalysisListenerException {
        this.endRule();
    }

    public void beginGroup(final Group group) throws AnalysisListenerException {
        final Date now = new Date();
        this.run(new XmlOperation(){

            @Override
            public void run() throws XMLStreamException {
                XmlReportWriter.this.xmlStreamWriter.writeStartElement("group");
                XmlReportWriter.this.xmlStreamWriter.writeAttribute("id", group.getId());
                XmlReportWriter.this.xmlStreamWriter.writeAttribute("date", XML_DATE_FORMAT.format(now));
            }
        });
        this.groupBeginTime = now.getTime();
    }

    public void endGroup() throws AnalysisListenerException {
        this.run(new XmlOperation(){

            @Override
            public void run() throws XMLStreamException {
                XmlReportWriter.this.writeDuration(XmlReportWriter.this.groupBeginTime);
                XmlReportWriter.this.xmlStreamWriter.writeEndElement();
            }
        });
    }

    public void beginConstraint(Constraint constraint) throws AnalysisListenerException {
        this.beginExecutable();
    }

    public void endConstraint() throws AnalysisListenerException {
        this.endRule();
    }

    public void setResult(Result<? extends ExecutableRule> result) throws AnalysisListenerException {
        this.result = result;
    }

    private void beginExecutable() {
        this.ruleBeginTime = System.currentTimeMillis();
    }

    private void endRule() throws AnalysisListenerException {
        if (this.result != null) {
            String elementName;
            final ExecutableRule rule = this.result.getRule();
            if (rule instanceof Concept) {
                elementName = "concept";
            } else if (rule instanceof Constraint) {
                elementName = "constraint";
            } else {
                throw new AnalysisListenerException("Cannot write report for unsupported rule " + rule);
            }
            final List columnNames = this.result.getColumnNames();
            final String primaryColumn = this.getPrimaryColumn(rule, columnNames);
            this.run(new XmlOperation(){

                @Override
                public void run() throws XMLStreamException, AnalysisListenerException {
                    XmlReportWriter.this.xmlStreamWriter.writeStartElement(elementName);
                    XmlReportWriter.this.xmlStreamWriter.writeAttribute("id", rule.getId());
                    XmlReportWriter.this.xmlStreamWriter.writeStartElement("description");
                    XmlReportWriter.this.xmlStreamWriter.writeCharacters(rule.getDescription());
                    XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                    if (!XmlReportWriter.this.result.isEmpty()) {
                        XmlReportWriter.this.xmlStreamWriter.writeStartElement("result");
                        XmlReportWriter.this.xmlStreamWriter.writeStartElement("columns");
                        XmlReportWriter.this.xmlStreamWriter.writeAttribute("count", Integer.toString(columnNames.size()));
                        for (String column : columnNames) {
                            XmlReportWriter.this.xmlStreamWriter.writeStartElement("column");
                            if (primaryColumn.equals(column)) {
                                XmlReportWriter.this.xmlStreamWriter.writeAttribute("primary", Boolean.TRUE.toString());
                            }
                            XmlReportWriter.this.xmlStreamWriter.writeCharacters(column);
                            XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                        }
                        XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                        XmlReportWriter.this.xmlStreamWriter.writeStartElement("rows");
                        List rows = XmlReportWriter.this.result.getRows();
                        XmlReportWriter.this.xmlStreamWriter.writeAttribute("count", Integer.toString(rows.size()));
                        for (Map row : rows) {
                            XmlReportWriter.this.xmlStreamWriter.writeStartElement("row");
                            for (Map.Entry rowEntry : row.entrySet()) {
                                String columnName = (String)rowEntry.getKey();
                                Object value = rowEntry.getValue();
                                XmlReportWriter.this.writeColumn(columnName, value);
                            }
                            XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                        }
                        XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                        XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                    }
                    XmlReportWriter.this.writeStatus(XmlReportWriter.this.result.getStatus());
                    XmlReportWriter.this.writeSeverity(XmlReportWriter.this.result.getSeverity());
                    XmlReportWriter.this.writeDuration(XmlReportWriter.this.ruleBeginTime);
                    XmlReportWriter.this.xmlStreamWriter.writeEndElement();
                }
            });
        }
    }

    private String getPrimaryColumn(ExecutableRule rule, List<String> columnNames) {
        String primaryColumn = rule.getReport().getPrimaryColumn();
        if (primaryColumn == null && columnNames != null && !columnNames.isEmpty()) {
            primaryColumn = columnNames.get(0);
        }
        return primaryColumn;
    }

    private void writeStatus(Result.Status status) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("status");
        this.xmlStreamWriter.writeCharacters(status.name().toLowerCase());
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeColumn(String columnName, Object value) throws XMLStreamException, AnalysisListenerException {
        this.xmlStreamWriter.writeStartElement("column");
        this.xmlStreamWriter.writeAttribute("name", columnName);
        String stringValue = null;
        if (value instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)value;
            LanguageElement elementValue = LanguageHelper.getLanguageElement(descriptor);
            if (elementValue != null) {
                this.xmlStreamWriter.writeStartElement("element");
                this.xmlStreamWriter.writeAttribute("language", elementValue.getLanguage());
                this.xmlStreamWriter.writeCharacters(elementValue.name());
                this.xmlStreamWriter.writeEndElement();
                SourceProvider<? extends Descriptor> sourceProvider = elementValue.getSourceProvider();
                stringValue = sourceProvider.getName((Descriptor)descriptor);
                String sourceFile = sourceProvider.getSourceFile((Descriptor)descriptor);
                Integer lineNumber = sourceProvider.getLineNumber((Descriptor)descriptor);
                if (sourceFile != null) {
                    this.xmlStreamWriter.writeStartElement("source");
                    this.xmlStreamWriter.writeAttribute("name", sourceFile);
                    if (lineNumber != null) {
                        this.xmlStreamWriter.writeAttribute("line", lineNumber.toString());
                    }
                    this.xmlStreamWriter.writeEndElement();
                }
            }
        } else if (value != null) {
            stringValue = ReportHelper.getStringValue(value);
        }
        this.xmlStreamWriter.writeStartElement("value");
        this.xmlStreamWriter.writeCharacters(stringValue);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeDuration(long beginTime) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("duration");
        this.xmlStreamWriter.writeCharacters(Long.toString(System.currentTimeMillis() - beginTime));
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeSeverity(Severity severity) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("severity");
        this.xmlStreamWriter.writeAttribute("level", severity.getLevel().toString());
        this.xmlStreamWriter.writeCharacters(severity.getValue());
        this.xmlStreamWriter.writeEndElement();
    }

    private void run(XmlOperation operation) throws AnalysisListenerException {
        try {
            operation.run();
        }
        catch (XMLStreamException e) {
            throw new AnalysisListenerException("Cannot write to XML report.", (Throwable)e);
        }
    }

    private static interface XmlOperation {
        public void run() throws XMLStreamException, AnalysisListenerException;
    }
}

