/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.AbstractTransferListener;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenIndex.class);
    private IndexingContext indexingContext;
    private PlexusContainer plexusContainer;
    private Indexer indexer;
    private String password;
    private String username;

    public MavenIndex(URL repoUrl, File repositoryDirectory, File indexDirectory, String username, String password) throws IOException {
        this.username = username;
        this.password = password;
        try {
            this.createIndexingContext(repoUrl, repositoryDirectory, indexDirectory);
        }
        catch (IllegalArgumentException | PlexusContainerException | ComponentLookupException e) {
            throw new IOException(e);
        }
    }

    public void closeIndexSearcher(IndexSearcher searcher) throws IOException {
        this.indexingContext.releaseIndexSearcher(searcher);
    }

    private void createIndexingContext(URL repoUrl, File repositoryDirectory, File indexDirectory) throws PlexusContainerException, ComponentLookupException, ExistingLuceneIndexMismatchException, IllegalArgumentException, IOException {
        this.plexusContainer = new DefaultPlexusContainer();
        this.indexer = (Indexer)this.plexusContainer.lookup(Indexer.class);
        String repoSuffix = repoUrl.getHost();
        File localIndexDir = new File(indexDirectory, "repo-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "min"));
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "jarContent"));
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "maven-plugin"));
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "maven-archetype"));
        this.indexingContext = this.indexer.createIndexingContext("jqa-cxt-" + repoSuffix, "jqa-repo-id-" + repoSuffix, repositoryDirectory, localIndexDir, repoUrl.toString(), null, true, true, indexers);
    }

    public void closeCurrentIndexingContext() throws IOException {
        this.indexer.closeIndexingContext(this.indexingContext, false);
    }

    public Iterable<ArtifactInfo> getArtifactsSince(Date startDate) throws IOException {
        final long startDateMillis = startDate.getTime();
        Query query = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("N/P"));
        IteratorSearchRequest request = new IteratorSearchRequest(query, Collections.singletonList(this.indexingContext), new ArtifactInfoFilter(){

            public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
                return startDateMillis < ai.lastModified;
            }
        });
        return this.indexer.searchIterator(request);
    }

    public IndexingContext getIndexingContext() {
        return this.indexingContext;
    }

    public Date getLastUpdateLocalRepo() {
        return this.getIndexingContext().getTimestamp();
    }

    public IndexSearcher newIndexSearcher() throws IOException {
        return this.indexingContext.acquireIndexSearcher();
    }

    public void updateIndex() throws IOException {
        Wagon httpWagon;
        IndexUpdater indexUpdater;
        try {
            indexUpdater = (IndexUpdater)this.plexusContainer.lookup(IndexUpdater.class);
            httpWagon = (Wagon)this.plexusContainer.lookup(Wagon.class, "http");
        }
        catch (ComponentLookupException e) {
            throw new IOException(e);
        }
        LOGGER.info("Updating repository index...");
        AbstractTransferListener listener = new AbstractTransferListener(){

            public void transferCompleted(TransferEvent transferEvent) {
                LOGGER.debug("Downloading " + transferEvent.getResource().getName() + " successful");
            }

            public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
            }

            public void transferStarted(TransferEvent transferEvent) {
                LOGGER.debug("Downloading " + transferEvent.getResource().getName());
            }
        };
        AuthenticationInfo info = null;
        if (this.username != null && this.password != null) {
            info = new AuthenticationInfo();
            info.setUserName(this.username);
            info.setPassword(this.password);
        }
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(httpWagon, (TransferListener)listener, info, null);
        Date lastUpdateLocalRepo = this.indexingContext.getTimestamp();
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.indexingContext, (ResourceFetcher)resourceFetcher);
        IndexUpdateResult updateResult = indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            LOGGER.debug("Received a full update.");
        } else if (updateResult.getTimestamp() == null) {
            LOGGER.debug("No update needed, index is up to date!");
        } else {
            LOGGER.debug("Received an incremental update, change covered " + lastUpdateLocalRepo + " - " + updateResult.getTimestamp() + " period.");
        }
    }
}

