/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.m2repo.api.ArtifactProvider;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.MavenIndex;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.MavenRepositoryArtifactResolver;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.MavenRepositoryFileResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherArtifactProvider
implements ArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherArtifactProvider.class);
    private MavenRepositoryDescriptor repositoryDescriptor;
    private URL url;
    private String username;
    private String password;
    private final File repositoryRoot;
    private MavenRepositoryFileResolver repositoryFileResolver;
    private MavenRepositoryArtifactResolver repositoryArtifactResolver;
    private final RemoteRepository repository;
    private final RepositorySystem repositorySystem;
    private final DefaultRepositorySystemSession session;

    public AetherArtifactProvider(URL repositoryUrl, MavenRepositoryDescriptor repositoryDescriptor, File workDirectory) {
        this.url = repositoryUrl;
        this.repositoryDescriptor = repositoryDescriptor;
        String userInfo = repositoryUrl.getUserInfo();
        this.username = StringUtils.substringBefore((String)userInfo, (String)":");
        this.password = StringUtils.substringAfter((String)userInfo, (String)":");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create new " + this.getClass().getSimpleName() + " for URL " + this.url);
        }
        AuthenticationBuilder authBuilder = new AuthenticationBuilder();
        if (this.username != null) {
            authBuilder.addUsername(this.username);
        }
        if (this.password != null) {
            authBuilder.addPassword(this.password);
        }
        Authentication auth = authBuilder.build();
        String url = StringUtils.replace((String)repositoryUrl.toString(), (String)(repositoryUrl.getUserInfo() + "@"), (String)"");
        String repositoryId = DigestUtils.md5Hex((String)repositoryUrl.toString());
        this.repository = new RemoteRepository.Builder(repositoryId, "default", url).setAuthentication(auth).build();
        this.repositorySystem = this.newRepositorySystem();
        this.repositoryFileResolver = new MavenRepositoryFileResolver(repositoryDescriptor);
        this.repositoryRoot = new File(workDirectory, repositoryId);
        this.repositoryArtifactResolver = new MavenRepositoryArtifactResolver(this.repositoryRoot, this.repositoryFileResolver);
        LOGGER.debug("Using '{}' for repository URL '{}'", (Object)this.repositoryRoot, (Object)repositoryUrl);
        this.session = this.newRepositorySystemSession(this.repositorySystem, this.repositoryRoot);
    }

    @Override
    public MavenRepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    @Override
    public ArtifactResult getArtifact(Artifact artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = this.createArtifactRequest(artifact);
        return this.repositorySystem.resolveArtifact((RepositorySystemSession)this.session, artifactRequest);
    }

    @Override
    public FileResolver getFileResolver() {
        return this.repositoryFileResolver;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.repositoryArtifactResolver;
    }

    public MavenIndex getMavenIndex() throws IOException {
        File indexRoot = new File(this.repositoryRoot, ".index");
        return new MavenIndex(this.url, indexRoot, indexRoot, this.username, this.password);
    }

    private ArtifactRequest createArtifactRequest(Artifact artifact) {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        List<RemoteRepository> repositories = Collections.singletonList(this.repository);
        artifactRequest.setRepositories(repositories);
        return artifactRequest;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, File localDirectory) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localDirectory);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }
}

