/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.sourceref;

import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;

public class ScmUrl {
    private static final String SCM_CONNECTION_PROPERTY = "tycho.scmUrl";
    private String type;
    private String url;

    public ScmUrl(Properties projectProperties) throws MojoExecutionException {
        this.url = projectProperties.getProperty(SCM_CONNECTION_PROPERTY);
        if (this.url == null) {
            throw new MojoExecutionException("Eclipse-SourceReferences header should be generated but ${tycho.scmUrl} is not set");
        }
        if (!this.url.startsWith("scm:")) {
            throw new MojoExecutionException("Invalid SCM URL: '" + this.url + "'. See http://maven.apache.org/scm/scm-url-format.html");
        }
        int delimiterIndex = -1;
        int pipeIndex = this.url.indexOf(124, 4);
        int colonIndex = this.url.indexOf(58, 4);
        delimiterIndex = pipeIndex > 0 ? (colonIndex > 0 ? Math.min(pipeIndex, colonIndex) : pipeIndex) : colonIndex;
        if (delimiterIndex == -1) {
            throw new MojoExecutionException("Invalid SCM URL: '" + this.url + "'. See http://maven.apache.org/scm/scm-url-format.html");
        }
        this.type = this.url.substring(4, delimiterIndex);
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }
}

