/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.neo4j.kernel.api.direct.NodeLabelRange;

public class LuceneNodeLabelRange
implements NodeLabelRange {
    private final int id;
    private final long[] nodeIds;
    private final long[][] labelIds;

    public LuceneNodeLabelRange(int id, long[] nodeIds, long[][] labelIds) {
        this.id = id;
        this.labelIds = labelIds;
        this.nodeIds = nodeIds;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("NodeLabelRange[docId=").append(this.id);
        result.append("; {");
        for (int i = 0; i < this.nodeIds.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append("Node[").append(this.nodeIds[i]).append("]: Labels[");
            String sep = "";
            for (long labelId : this.labelIds[i]) {
                result.append(sep).append(labelId);
                sep = ", ";
            }
            result.append("]");
        }
        return result.append("}]").toString();
    }

    public int id() {
        return this.id;
    }

    public long[] nodes() {
        return this.nodeIds;
    }

    public long[] labels(long nodeId) {
        for (int i = 0; i < this.nodeIds.length; ++i) {
            if (nodeId != this.nodeIds[i]) continue;
            return this.labelIds[i];
        }
        throw new IllegalArgumentException("Unknown nodeId: " + nodeId);
    }

    public static LuceneNodeLabelRange fromBitmapStructure(int id, long[] labelIds, long[][] nodeIdsByLabelIndex) {
        HashMap<Long, ArrayList<Long>> labelsForEachNode = new HashMap<Long, ArrayList<Long>>();
        for (int i = 0; i < labelIds.length; ++i) {
            long labelId = labelIds[i];
            for (int j = 0; j < nodeIdsByLabelIndex[i].length; ++j) {
                long nodeId = nodeIdsByLabelIndex[i][j];
                ArrayList<Long> labelIdList = (ArrayList<Long>)labelsForEachNode.get(nodeId);
                if (labelIdList == null) {
                    labelIdList = new ArrayList<Long>();
                    labelsForEachNode.put(nodeId, labelIdList);
                }
                labelIdList.add(labelId);
            }
        }
        Set nodeIdSet = labelsForEachNode.keySet();
        long[] nodeIds = new long[nodeIdSet.size()];
        long[][] labelIdsByNodeIndex = new long[nodeIdSet.size()][];
        int nodeIndex = 0;
        Iterator i$ = nodeIdSet.iterator();
        while (i$.hasNext()) {
            long nodeId;
            nodeIds[nodeIndex] = nodeId = ((Long)i$.next()).longValue();
            List labelIdList = (List)labelsForEachNode.get(nodeId);
            long[] nodeLabelIds = new long[labelIdList.size()];
            int labelIndex = 0;
            Iterator i$2 = labelIdList.iterator();
            while (i$2.hasNext()) {
                long labelId;
                nodeLabelIds[labelIndex] = labelId = ((Long)i$2.next()).longValue();
                ++labelIndex;
            }
            labelIdsByNodeIndex[nodeIndex] = nodeLabelIds;
            ++nodeIndex;
        }
        return new LuceneNodeLabelRange(id, nodeIds, labelIdsByNodeIndex);
    }
}

