/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;

public class LuceneIndexWriter
implements Closeable {
    private static final long MAX_DOC_LIMIT = 0x7FFFFF7FL;
    private static final String KEY_STATUS = "status";
    private static final String ONLINE = "online";
    private static final Map<String, String> ONLINE_COMMIT_USER_DATA = Collections.singletonMap("status", "online");
    protected final IndexWriter writer;

    LuceneIndexWriter(Directory dir, IndexWriterConfig conf) throws IOException {
        this.writer = new IndexWriter(dir, conf);
    }

    public static boolean isOnline(Directory directory) throws IOException {
        if (!IndexReader.indexExists((Directory)directory)) {
            return false;
        }
        try (IndexReader reader = IndexReader.open((Directory)directory);){
            Map userData = reader.getIndexCommit().getUserData();
            boolean bl = ONLINE.equals(userData.get(KEY_STATUS));
            return bl;
        }
    }

    public void addDocument(Document document) throws IOException, IndexCapacityExceededException {
        this.writer.addDocument(document);
    }

    public void updateDocument(Term term, Document document) throws IOException, IndexCapacityExceededException {
        this.writer.updateDocument(term, document);
    }

    public void deleteDocuments(Term term) throws IOException {
        this.writer.deleteDocuments(term);
    }

    public void deleteDocuments(Query query) throws IOException {
        this.writer.deleteDocuments(query);
    }

    public void optimize() throws IOException {
        this.writer.optimize(true);
    }

    public SearcherManager createSearcherManager() throws IOException {
        return new SearcherManager(this.writer, true, new SearcherFactory());
    }

    public void commit() throws IOException {
        this.writer.commit();
    }

    public void commitAsOnline() throws IOException {
        this.writer.commit(ONLINE_COMMIT_USER_DATA);
    }

    @Override
    public void close() throws IOException {
        this.writer.close(true);
    }

    IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.writer.getConfig().getIndexDeletionPolicy();
    }

    long maxDocLimit() {
        return 0x7FFFFF7FL;
    }
}

