/*
 * Decompiled with CFR 0.152.
 */
package com.burakustun.lottieprogressdialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.Window;
import com.airbnb.lottie.LottieAnimationView;
import com.burakustun.lottieprogressdialog.R;

public class LottieDialogFragment
extends DialogFragment {
    String jsonFileName;
    boolean isLoopEnabled;
    LottieProgressDialog progressDialog;

    public LottieDialogFragment newInstance(String jsonFileName) {
        LottieDialogFragment fragment = new LottieDialogFragment();
        Bundle args = new Bundle();
        args.putString("jsonFileName", jsonFileName);
        args.putBoolean("isLoopEnabled", true);
        fragment.setArguments(args);
        return fragment;
    }

    public LottieDialogFragment newInstance(String jsonFileName, boolean isLoopEnabled) {
        LottieDialogFragment fragment = new LottieDialogFragment();
        Bundle args = new Bundle();
        args.putString("jsonFileName", jsonFileName);
        args.putBoolean("isLoopEnabled", isLoopEnabled);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.jsonFileName = this.getArguments().getString("jsonFileName");
        this.isLoopEnabled = this.getArguments().getBoolean("isLoopEnabled");
        this.progressDialog = new LottieProgressDialog((Context)this.getActivity());
        this.progressDialog.setJsonFileName(this.jsonFileName);
        this.progressDialog.setLoop(this.isLoopEnabled);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return this.progressDialog;
    }

    private class LottieProgressDialog
    extends AlertDialog {
        private LottieAnimationView lavProgress;
        private String jsonFileName;
        private boolean loop;

        private LottieProgressDialog(Context context) {
            super(context);
            this.loop = true;
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setContentView(R.layout.lottie_progress_dialog);
            Window currentWindow = this.getWindow();
            if (currentWindow != null) {
                currentWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            }
            this.lavProgress = (LottieAnimationView)this.findViewById(R.id.lavProgress);
            this.lavProgress.setAnimation(this.jsonFileName);
            this.lavProgress.loop(this.loop);
            this.lavProgress.playAnimation();
        }

        public void dismiss() {
            if (this.lavProgress != null) {
                this.lavProgress.cancelAnimation();
            }
            super.dismiss();
        }

        private String getJsonFileName() {
            return this.jsonFileName;
        }

        private void setJsonFileName(String jsonFileName) {
            this.jsonFileName = jsonFileName;
        }

        private boolean isLoop() {
            return this.loop;
        }

        private void setLoop(boolean loop) {
            this.loop = loop;
        }
    }
}

