/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509.tsp;

import java.math.BigInteger;
import java.util.Date;
import org.apache.harmony.security.asn1.ASN1Boolean;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1GeneralizedTime;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Integer;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;
import org.apache.harmony.security.x509.Extensions;
import org.apache.harmony.security.x509.GeneralName;
import org.apache.harmony.security.x509.tsp.MessageImprint;

public class TSTInfo {
    private final int version;
    private final String policy;
    private final MessageImprint messageImprint;
    private final BigInteger serialNumber;
    private final Date genTime;
    private final int[] accuracy;
    private final Boolean ordering;
    private final BigInteger nonce;
    private final GeneralName tsa;
    private final Extensions extensions;
    public static final ASN1Sequence ACCURACY = new ASN1Sequence(new ASN1Type[]{ASN1Integer.getInstance(), ASN1Integer.getInstance(), ASN1Integer.getInstance()}){
        {
            this.setOptional(0);
            this.setOptional(1);
            this.setOptional(2);
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) {
            Object[] values2 = (Object[])in.content;
            int[] accuracy = new int[3];
            for (int i = 0; i < 3; ++i) {
                if (values2[i] == null) continue;
                accuracy[i] = ASN1Integer.toIntValue(values2[i]);
                if (i <= 0 || accuracy[i] >= 0 && accuracy[i] <= 999) continue;
                throw new RuntimeException("Time-stamp accuracy value is incorrect: " + accuracy[i]);
            }
            return accuracy;
        }

        @Override
        protected void getValues(Object object, Object[] values2) {
            int[] accuracy = (int[])object;
            for (int i = 0; i < 3; ++i) {
                if (i > 0 && (accuracy[i] < 0 || accuracy[i] > 999)) {
                    throw new RuntimeException("Time-stamp accuracy value is incorrect: " + accuracy[i]);
                }
                values2[i] = BigInteger.valueOf(accuracy[i]).toByteArray();
            }
        }
    };
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{ASN1Integer.getInstance(), ASN1Oid.getInstance(), MessageImprint.ASN1, ASN1Integer.getInstance(), ASN1GeneralizedTime.getInstance(), ACCURACY, ASN1Boolean.getInstance(), ASN1Integer.getInstance(), new ASN1Explicit(0, GeneralName.ASN1), new ASN1Implicit(1, Extensions.ASN1)}){
        {
            this.setOptional(5);
            this.setDefault(Boolean.FALSE, 6);
            this.setOptional(7);
            this.setOptional(8);
            this.setOptional(9);
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) {
            Object[] values2 = (Object[])in.content;
            BigInteger nonce = values2[7] == null ? null : new BigInteger((byte[])values2[7]);
            return new TSTInfo(ASN1Integer.toIntValue(values2[0]), ObjectIdentifier.toString((int[])values2[1]), (MessageImprint)values2[2], new BigInteger((byte[])values2[3]), (Date)values2[4], (int[])values2[5], (Boolean)values2[6], nonce, (GeneralName)values2[8], (Extensions)values2[9]);
        }

        @Override
        protected void getValues(Object object, Object[] values2) {
            TSTInfo info = (TSTInfo)object;
            values2[0] = ASN1Integer.fromIntValue(info.version);
            values2[1] = ObjectIdentifier.toIntArray(info.policy);
            values2[2] = info.messageImprint;
            values2[3] = info.serialNumber.toByteArray();
            values2[4] = info.genTime;
            values2[5] = info.accuracy;
            values2[6] = info.ordering;
            values2[7] = info.nonce == null ? null : info.nonce.toByteArray();
            values2[8] = info.tsa;
            values2[9] = info.extensions;
        }
    };

    public TSTInfo(int version, String policy, MessageImprint messageImprint, BigInteger serialNumber, Date genTime, int[] accuracy, Boolean ordering, BigInteger nonce, GeneralName tsa, Extensions extensions) {
        this.version = version;
        this.policy = policy;
        this.messageImprint = messageImprint;
        this.serialNumber = serialNumber;
        this.genTime = genTime;
        this.accuracy = accuracy;
        this.ordering = ordering;
        this.nonce = nonce;
        this.tsa = tsa;
        this.extensions = extensions;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("-- TSTInfo:");
        res.append("\nversion:  ");
        res.append(this.version);
        res.append("\npolicy:  ");
        res.append(this.policy);
        res.append("\nmessageImprint:  ");
        res.append(this.messageImprint);
        res.append("\nserialNumber:  ");
        res.append(this.serialNumber);
        res.append("\ngenTime:  ");
        res.append(this.genTime);
        res.append("\naccuracy:  ");
        if (this.accuracy != null) {
            res.append(this.accuracy[0] + " sec, " + this.accuracy[1] + " millis, " + this.accuracy[2] + " micros");
        }
        res.append("\nordering:  ");
        res.append(this.ordering);
        res.append("\nnonce:  ");
        res.append(this.nonce);
        res.append("\ntsa:  ");
        res.append(this.tsa);
        res.append("\nextensions:  ");
        res.append(this.extensions);
        res.append("\n-- TSTInfo End\n");
        return res.toString();
    }

    public int[] getAccuracy() {
        return this.accuracy;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public Date getGenTime() {
        return this.genTime;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public Boolean getOrdering() {
        return this.ordering;
    }

    public String getPolicy() {
        return this.policy;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public GeneralName getTsa() {
        return this.tsa;
    }

    public int getVersion() {
        return this.version;
    }
}

