/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Set;
import org.apache.harmony.security.asn1.ASN1SetOf;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.ASN1ValueCollection;

public class BerInputStream {
    private final InputStream in;
    protected byte[] buffer;
    protected int offset = 0;
    private static final int BUF_INCREASE_SIZE = 16384;
    protected static final int INDEFINIT_LENGTH = -1;
    public int tag;
    protected int length;
    public Object content;
    protected int tagOffset;
    protected int contentOffset;
    public int choiceIndex;
    public int[] times;
    public int oidElement;
    protected boolean isVerify;
    protected boolean isIndefinedLength;
    private Object[][] pool;

    public BerInputStream(byte[] encoded) throws IOException {
        this(encoded, 0, encoded.length);
    }

    public BerInputStream(byte[] encoded, int offset, int expectedLength) throws IOException {
        this.in = null;
        this.buffer = encoded;
        this.offset = offset;
        this.next();
        if (this.length != -1 && offset + expectedLength != this.offset + this.length) {
            throw new ASN1Exception("Wrong content length");
        }
    }

    public BerInputStream(InputStream in) throws IOException {
        this(in, 16384);
    }

    public BerInputStream(InputStream in, int initialSize) throws IOException {
        this.in = in;
        this.buffer = new byte[initialSize];
        this.next();
        if (this.length != -1) {
            if (this.buffer.length < this.length + this.offset) {
                byte[] newBuffer = new byte[this.length + this.offset];
                System.arraycopy((Object)this.buffer, 0, (Object)newBuffer, 0, this.offset);
                this.buffer = newBuffer;
            }
        } else {
            this.isIndefinedLength = true;
            throw new ASN1Exception("Decoding indefinite length encoding is not supported");
        }
    }

    public final void reset(byte[] encoded) throws IOException {
        this.buffer = encoded;
        this.next();
    }

    public int next() throws IOException {
        this.tagOffset = this.offset;
        this.tag = this.read();
        this.length = this.read();
        if (this.length != 128) {
            if ((this.length & 0x80) != 0) {
                int numOctets = this.length & 0x7F;
                if (numOctets > 5) {
                    throw new ASN1Exception("Too long encoding at [" + this.tagOffset + "]");
                }
                this.length = this.read();
                for (int i = 1; i < numOctets; ++i) {
                    int ch = this.read();
                    this.length = (this.length << 8) + ch;
                }
                if (this.length > 0xFFFFFF) {
                    throw new ASN1Exception("Too long encoding at [" + this.tagOffset + "]");
                }
            }
        } else {
            this.length = -1;
        }
        this.contentOffset = this.offset;
        return this.tag;
    }

    public static int getLength(byte[] encoding) {
        int length = encoding[1] & 0xFF;
        int numOctets = 0;
        if ((length & 0x80) != 0) {
            numOctets = length & 0x7F;
            length = encoding[2] & 0xFF;
            for (int i = 3; i < numOctets + 2; ++i) {
                length = (length << 8) + (encoding[i] & 0xFF);
            }
        }
        return 2 + numOctets + length;
    }

    public void readBitString() throws IOException {
        if (this.tag == 3) {
            if (this.length == 0) {
                throw new ASN1Exception("ASN.1 Bitstring: wrong length. Tag at [" + this.tagOffset + "]");
            }
            this.readContent();
            if (this.buffer[this.contentOffset] > 7) {
                throw new ASN1Exception("ASN.1 Bitstring: wrong content at [" + this.contentOffset + "]. A number of unused bits MUST be in range 0 to 7");
            }
            if (this.length == 1 && this.buffer[this.contentOffset] != 0) {
                throw new ASN1Exception("ASN.1 Bitstring: wrong content at [" + this.contentOffset + "]. For empty string unused bits MUST be 0");
            }
        } else {
            if (this.tag == 35) {
                throw new ASN1Exception("Decoding constructed ASN.1 bitstring  type is not provided");
            }
            throw this.expected("bitstring");
        }
    }

    public void readEnumerated() throws IOException {
        if (this.tag != 10) {
            throw this.expected("enumerated");
        }
        if (this.length == 0) {
            throw new ASN1Exception("ASN.1 enumerated: wrong length for identifier at [" + this.tagOffset + "]");
        }
        this.readContent();
        if (this.length > 1) {
            int bits = this.buffer[this.contentOffset] & 0xFF;
            if (this.buffer[this.contentOffset + 1] < 0) {
                bits += 256;
            }
            if (bits == 0 || bits == 511) {
                throw new ASN1Exception("ASN.1 enumerated: wrong content at [" + this.contentOffset + "]. An integer MUST be encoded in minimum number of octets");
            }
        }
    }

    public void readBoolean() throws IOException {
        if (this.tag != 1) {
            throw this.expected("boolean");
        }
        if (this.length != 1) {
            throw new ASN1Exception("Wrong length for ASN.1 boolean at [" + this.tagOffset + "]");
        }
        this.readContent();
    }

    public void readGeneralizedTime() throws IOException {
        if (this.tag == 24) {
            byte char14;
            this.readContent();
            if (this.buffer[this.offset - 1] != 90) {
                throw new ASN1Exception("ASN.1 GeneralizedTime: encoded format is not implemented");
            }
            if (this.length != 15 && (this.length < 17 || this.length > 19)) {
                throw new ASN1Exception("ASN.1 GeneralizedTime wrongly encoded at [" + this.contentOffset + "]");
            }
            if (this.length > 16 && (char14 = this.buffer[this.contentOffset + 14]) != 46 && char14 != 44) {
                throw new ASN1Exception("ASN.1 GeneralizedTime wrongly encoded at [" + this.contentOffset + "]");
            }
            if (this.times == null) {
                this.times = new int[7];
            }
            this.times[0] = this.strToInt(this.contentOffset, 4);
            this.times[1] = this.strToInt(this.contentOffset + 4, 2);
            this.times[2] = this.strToInt(this.contentOffset + 6, 2);
            this.times[3] = this.strToInt(this.contentOffset + 8, 2);
            this.times[4] = this.strToInt(this.contentOffset + 10, 2);
            this.times[5] = this.strToInt(this.contentOffset + 12, 2);
            if (this.length > 16) {
                this.times[6] = this.strToInt(this.contentOffset + 15, this.length - 16);
                if (this.length == 17) {
                    this.times[6] = this.times[6] * 100;
                } else if (this.length == 18) {
                    this.times[6] = this.times[6] * 10;
                }
            }
        } else {
            if (this.tag == 56) {
                throw new ASN1Exception("Decoding constructed ASN.1 GeneralizedTime type is not supported");
            }
            throw this.expected("GeneralizedTime");
        }
    }

    public void readUTCTime() throws IOException {
        if (this.tag == 23) {
            switch (this.length) {
                case 11: 
                case 13: {
                    break;
                }
                case 15: 
                case 17: {
                    throw new ASN1Exception("ASN.1 UTCTime: local time format is not supported");
                }
                default: {
                    throw new ASN1Exception("ASN.1 UTCTime: wrong length, identifier at " + this.tagOffset);
                }
            }
            this.readContent();
            if (this.buffer[this.offset - 1] != 90) {
                throw new ASN1Exception("ASN.1 UTCTime wrongly encoded at [" + this.contentOffset + ']');
            }
            if (this.times == null) {
                this.times = new int[7];
            }
            this.times[0] = this.strToInt(this.contentOffset, 2);
            this.times[0] = this.times[0] > 49 ? this.times[0] + 1900 : this.times[0] + 2000;
            this.times[1] = this.strToInt(this.contentOffset + 2, 2);
            this.times[2] = this.strToInt(this.contentOffset + 4, 2);
            this.times[3] = this.strToInt(this.contentOffset + 6, 2);
            this.times[4] = this.strToInt(this.contentOffset + 8, 2);
            if (this.length == 13) {
                this.times[5] = this.strToInt(this.contentOffset + 10, 2);
            }
        } else {
            if (this.tag == 55) {
                throw new ASN1Exception("Decoding constructed ASN.1 UTCTime type is not supported");
            }
            throw this.expected("UTCTime");
        }
    }

    private int strToInt(int off, int count) throws ASN1Exception {
        int result = 0;
        int end = off + count;
        for (int i = off; i < end; ++i) {
            int c = this.buffer[i] - 48;
            if (c < 0 || c > 9) {
                throw new ASN1Exception("Time encoding has invalid char");
            }
            result = result * 10 + c;
        }
        return result;
    }

    public void readInteger() throws IOException {
        if (this.tag != 2) {
            throw this.expected("integer");
        }
        if (this.length < 1) {
            throw new ASN1Exception("Wrong length for ASN.1 integer at [" + this.tagOffset + "]");
        }
        this.readContent();
        if (this.length > 1) {
            byte firstByte = this.buffer[this.offset - this.length];
            byte secondByte = (byte)(this.buffer[this.offset - this.length + 1] & 0x80);
            if (firstByte == 0 && secondByte == 0 || firstByte == -1 && secondByte == -128) {
                throw new ASN1Exception("Wrong content for ASN.1 integer at [" + (this.offset - this.length) + "]. An integer MUST be encoded in minimum number of octets");
            }
        }
    }

    public void readOctetString() throws IOException {
        if (this.tag != 4) {
            if (this.tag == 36) {
                throw new ASN1Exception("Decoding constructed ASN.1 octet string type is not supported");
            }
            throw this.expected("octetstring");
        }
        this.readContent();
    }

    private ASN1Exception expected(String what) throws ASN1Exception {
        throw new ASN1Exception("ASN.1 " + what + " identifier expected at [" + this.tagOffset + "], got " + Integer.toHexString(this.tag));
    }

    public void readOID() throws IOException {
        if (this.tag != 6) {
            throw this.expected("OID");
        }
        if (this.length < 1) {
            throw new ASN1Exception("Wrong length for ASN.1 object identifier at [" + this.tagOffset + "]");
        }
        this.readContent();
        if ((this.buffer[this.offset - 1] & 0x80) != 0) {
            throw new ASN1Exception("Wrong encoding at [" + (this.offset - 1) + "]");
        }
        this.oidElement = 1;
        int i = 0;
        while (i < this.length) {
            while ((this.buffer[this.contentOffset + i] & 0x80) == 128) {
                ++i;
            }
            ++i;
            ++this.oidElement;
        }
    }

    public void readSequence(ASN1Sequence sequence) throws IOException {
        int i;
        if (this.tag != 48) {
            throw this.expected("sequence");
        }
        int begOffset = this.offset;
        int endOffset = begOffset + this.length;
        ASN1Type[] type = sequence.type;
        if (this.isVerify) {
            for (i = 0; this.offset < endOffset && i < type.length; ++i) {
                this.next();
                while (!type[i].checkTag(this.tag)) {
                    if (!sequence.OPTIONAL[i] || i == type.length - 1) {
                        throw new ASN1Exception("ASN.1 Sequence: mandatory value is missing at [" + this.tagOffset + "]");
                    }
                    ++i;
                }
                type[i].decode(this);
            }
            while (i < type.length) {
                if (!sequence.OPTIONAL[i]) {
                    throw new ASN1Exception("ASN.1 Sequence: mandatory value is missing at [" + this.tagOffset + "]");
                }
                ++i;
            }
        } else {
            int seqTagOffset = this.tagOffset;
            Object[] values2 = new Object[type.length];
            while (this.offset < endOffset && i < type.length) {
                this.next();
                while (!type[i].checkTag(this.tag)) {
                    if (!sequence.OPTIONAL[i] || i == type.length - 1) {
                        throw new ASN1Exception("ASN.1 Sequence: mandatory value is missing at [" + this.tagOffset + "]");
                    }
                    if (sequence.DEFAULT[i] != null) {
                        values2[i] = sequence.DEFAULT[i];
                    }
                    ++i;
                }
                values2[i] = type[i].decode(this);
                ++i;
            }
            while (i < type.length) {
                if (!sequence.OPTIONAL[i]) {
                    throw new ASN1Exception("ASN.1 Sequence: mandatory value is missing at [" + this.tagOffset + "]");
                }
                if (sequence.DEFAULT[i] != null) {
                    values2[i] = sequence.DEFAULT[i];
                }
                ++i;
            }
            this.content = values2;
            this.tagOffset = seqTagOffset;
        }
        if (this.offset != endOffset) {
            throw new ASN1Exception("Wrong encoding at [" + begOffset + "]. Content's length and encoded length are not the same");
        }
    }

    public void readSequenceOf(ASN1SequenceOf sequenceOf) throws IOException {
        if (this.tag != 48) {
            throw this.expected("sequenceOf");
        }
        this.decodeValueCollection(sequenceOf);
    }

    public void readSet(ASN1Set set) throws IOException {
        if (this.tag != 49) {
            throw this.expected("set");
        }
        throw new ASN1Exception("Decoding ASN.1 Set type is not supported");
    }

    public void readSetOf(ASN1SetOf setOf) throws IOException {
        if (this.tag != 49) {
            throw this.expected("setOf");
        }
        this.decodeValueCollection(setOf);
    }

    private void decodeValueCollection(ASN1ValueCollection collection) throws IOException {
        int begOffset = this.offset;
        int endOffset = begOffset + this.length;
        ASN1Type type = collection.type;
        if (this.isVerify) {
            while (endOffset > this.offset) {
                this.next();
                type.decode(this);
            }
        } else {
            int seqTagOffset = this.tagOffset;
            ArrayList<Object> values2 = new ArrayList<Object>();
            while (endOffset > this.offset) {
                this.next();
                values2.add(type.decode(this));
            }
            values2.trimToSize();
            this.content = values2;
            this.tagOffset = seqTagOffset;
        }
        if (this.offset != endOffset) {
            throw new ASN1Exception("Wrong encoding at [" + begOffset + "]. Content's length and encoded length are not the same");
        }
    }

    public void readString(ASN1StringType type) throws IOException {
        if (this.tag != type.id) {
            if (this.tag == type.constrId) {
                throw new ASN1Exception("Decoding constructed ASN.1 string type is not provided");
            }
            throw this.expected("string");
        }
        this.readContent();
    }

    public byte[] getEncoded() {
        byte[] encoded = new byte[this.offset - this.tagOffset];
        System.arraycopy((Object)this.buffer, this.tagOffset, (Object)encoded, 0, encoded.length);
        return encoded;
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getEndOffset() {
        return this.offset + this.length;
    }

    public final int getTagOffset() {
        return this.tagOffset;
    }

    public final void setVerify() {
        this.isVerify = true;
    }

    protected int read() throws IOException {
        if (this.offset == this.buffer.length) {
            throw new ASN1Exception("Unexpected end of encoding");
        }
        if (this.in == null) {
            return this.buffer[this.offset++] & 0xFF;
        }
        int octet = this.in.read();
        if (octet == -1) {
            throw new ASN1Exception("Unexpected end of encoding");
        }
        this.buffer[this.offset++] = (byte)octet;
        return octet;
    }

    public void readContent() throws IOException {
        if (this.offset + this.length > this.buffer.length) {
            throw new ASN1Exception("Unexpected end of encoding");
        }
        if (this.in == null) {
            this.offset += this.length;
        } else {
            int bytesRead = this.in.read(this.buffer, this.offset, this.length);
            if (bytesRead != this.length) {
                int c = bytesRead;
                do {
                    if (c >= 1 && bytesRead <= this.length) continue;
                    throw new ASN1Exception("Failed to read encoded content");
                } while ((bytesRead += (c = this.in.read(this.buffer, this.offset + bytesRead, this.length - bytesRead))) != this.length);
            }
            this.offset += this.length;
        }
    }

    public void compactBuffer() {
        if (this.offset != this.buffer.length) {
            byte[] newBuffer = new byte[this.offset];
            System.arraycopy((Object)this.buffer, 0, (Object)newBuffer, 0, this.offset);
            this.buffer = newBuffer;
        }
    }

    public void put(Object key, Object entry) {
        int i;
        if (this.pool == null) {
            this.pool = new Object[2][10];
        }
        for (i = 0; i < this.pool[0].length && this.pool[0][i] != null; ++i) {
            if (this.pool[0][i] != key) continue;
            this.pool[1][i] = entry;
            return;
        }
        if (i == this.pool[0].length) {
            Object[][] newPool = new Object[this.pool[0].length * 2][2];
            System.arraycopy((Object)this.pool[0], 0, (Object)newPool[0], 0, this.pool[0].length);
            System.arraycopy((Object)this.pool[1], 0, (Object)newPool[1], 0, this.pool[0].length);
            this.pool = newPool;
        } else {
            this.pool[0][i] = key;
            this.pool[1][i] = entry;
        }
    }

    public Object get(Object key) {
        if (this.pool == null) {
            return null;
        }
        for (int i = 0; i < this.pool[0].length; ++i) {
            if (this.pool[0][i] != key) continue;
            return this.pool[1][i];
        }
        return null;
    }
}

