/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import libcore.io.BufferIterator;
import libcore.io.HeapBufferIterator;
import libcore.io.IoUtils;
import libcore.util.ZoneInfo;
import libcore.util.ZoneInfoDB;

final class TzDataBugVM
extends ZoneInfoDB.TzData {
    private static final String ZONE_DIRECTORY_NAME = "/usr/share/zoneinfo/";
    private static final String VERSION = TzDataBugVM.readVersion();
    private static final Map<String, String> deprecatedAliases = new HashMap<String, String>();
    private static ZoneInfo[] zoneInfos;
    private String zoneTab;
    private static String[] ids;

    TzDataBugVM() {
    }

    private static String readVersion() {
        try {
            byte[] bytes = IoUtils.readFileAsByteArray("/usr/share/zoneinfo/+VERSION");
            return new String(bytes, 0, bytes.length, StandardCharsets.ISO_8859_1).trim();
        }
        catch (IOException ex) {
            return "unknown";
        }
    }

    private static void readIndex() {
        try {
            TzDataBugVM.readIndexMulti();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        zoneInfos = new ZoneInfo[ids.length];
    }

    private static void readIndexMulti() throws IOException {
        TreeSet<String> set = new TreeSet<String>();
        for (File f1 : new File(ZONE_DIRECTORY_NAME).listFiles()) {
            String name1 = f1.getName();
            if ("Factory".equals(name1) || name1.charAt(0) < 'A' || name1.charAt(0) > 'Z') continue;
            if (f1.isDirectory()) {
                for (File f2 : f1.listFiles()) {
                    String name2 = f2.getName();
                    if (name2.charAt(0) < 'A' || name2.charAt(0) > 'Z') continue;
                    if (f2.isDirectory()) {
                        for (File f3 : f2.listFiles()) {
                            String name3 = f3.getName();
                            if (name3.charAt(0) < 'A' || name3.charAt(0) > 'Z' || f3.isDirectory()) continue;
                            set.add(name1 + "/" + name2 + "/" + name3);
                        }
                        continue;
                    }
                    set.add(name1 + "/" + name2);
                }
                continue;
            }
            set.add(name1);
        }
        for (Map.Entry entry : deprecatedAliases.entrySet()) {
            if (!set.contains(entry.getValue())) continue;
            set.add((String)entry.getKey());
        }
        ids = set.toArray(new String[set.size()]);
    }

    @Override
    public TimeZone makeTimeZone(String id) throws IOException {
        return this.makeTimeZone(id, true);
    }

    private TimeZone makeTimeZone(String id, boolean clone) throws IOException {
        String realId = deprecatedAliases.get(id);
        if (realId != null) {
            return this.makeTimeZone(realId, clone);
        }
        int index = Arrays.binarySearch(ids, id);
        if (index < 0) {
            return null;
        }
        ZoneInfo zoneInfo = zoneInfos[index];
        if (zoneInfo != null) {
            return clone ? (TimeZone)zoneInfo.clone() : zoneInfo;
        }
        byte[] bytes = IoUtils.readFileAsByteArray(ZONE_DIRECTORY_NAME + id);
        BufferIterator it = HeapBufferIterator.iterator(bytes, 0, bytes.length, ByteOrder.BIG_ENDIAN);
        TzDataBugVM.zoneInfos[index] = zoneInfo = (ZoneInfo)ZoneInfo.makeTimeZone(id, it);
        return clone ? (TimeZone)zoneInfo.clone() : zoneInfo;
    }

    @Override
    public String[] getAvailableIDs() {
        return (String[])ids.clone();
    }

    @Override
    public String[] getAvailableIDs(int rawOffset) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String id : ids) {
            try {
                TimeZone timeZone = this.makeTimeZone(id, false);
                if (timeZone.getRawOffset() != rawOffset) continue;
                matches.add(id);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return matches.toArray(new String[matches.size()]);
    }

    @Override
    public String getZoneTab() {
        if (this.zoneTab == null) {
            try {
                this.zoneTab = IoUtils.readFileAsString("/usr/share/zoneinfo/zone.tab");
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return this.zoneTab;
    }

    @Override
    public String getDefaultID() {
        String zoneName = null;
        try {
            zoneName = IoUtils.readFileAsString("/etc/timezone").trim();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (zoneName == null || zoneName.isEmpty()) {
            File link = new File("/etc/localtime");
            if (!link.exists()) {
                link = new File("/private/var/db/timezone/localtime");
            }
            try {
                String path = link.getCanonicalPath();
                for (String id : ids) {
                    if (!path.endsWith(id)) continue;
                    zoneName = id;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return zoneName;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    static {
        deprecatedAliases.put("ACT", "Australia/Darwin");
        deprecatedAliases.put("AET", "Australia/Sydney");
        deprecatedAliases.put("AGT", "America/Argentina/Buenos_Aires");
        deprecatedAliases.put("ART", "Africa/Cairo");
        deprecatedAliases.put("AST", "America/Juneau");
        deprecatedAliases.put("BET", "Etc/GMT-11");
        deprecatedAliases.put("BST", "Asia/Colombo");
        deprecatedAliases.put("CAT", "Africa/Gaborone");
        deprecatedAliases.put("CNT", "America/St_Johns");
        deprecatedAliases.put("CST", "CST6CDT");
        deprecatedAliases.put("CTT", "Asia/Brunei");
        deprecatedAliases.put("EAT", "Indian/Comoro");
        deprecatedAliases.put("ECT", "CET");
        deprecatedAliases.put("EST", "EST5EDT");
        deprecatedAliases.put("EST5", "EST5EDT");
        deprecatedAliases.put("IET", "EST5EDT");
        deprecatedAliases.put("IST", "Asia/Calcutta");
        deprecatedAliases.put("JST", "Asia/Seoul");
        deprecatedAliases.put("MIT", "Pacific/Niue");
        deprecatedAliases.put("MST", "MST7MDT");
        deprecatedAliases.put("MST7", "MST7MDT");
        deprecatedAliases.put("NET", "Indian/Mauritius");
        deprecatedAliases.put("NST", "Pacific/Auckland");
        deprecatedAliases.put("PLT", "Indian/Kerguelen");
        deprecatedAliases.put("PNT", "MST7MDT");
        deprecatedAliases.put("PRT", "America/Anguilla");
        deprecatedAliases.put("PST", "PST8PDT");
        deprecatedAliases.put("SST", "Pacific/Ponape");
        deprecatedAliases.put("VST", "Asia/Bangkok");
        TzDataBugVM.readIndex();
    }
}

