/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

public abstract class SSLEngine {
    private final String peerHost;
    private final int peerPort;

    protected SSLEngine() {
        this.peerHost = null;
        this.peerPort = -1;
    }

    protected SSLEngine(String host, int port) {
        this.peerHost = host;
        this.peerPort = port;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public abstract void beginHandshake() throws SSLException;

    public abstract void closeInbound() throws SSLException;

    public abstract void closeOutbound();

    public abstract Runnable getDelegatedTask();

    public abstract String[] getEnabledCipherSuites();

    public abstract String[] getEnabledProtocols();

    public abstract boolean getEnableSessionCreation();

    public abstract SSLEngineResult.HandshakeStatus getHandshakeStatus();

    public abstract boolean getNeedClientAuth();

    public abstract SSLSession getSession();

    public abstract String[] getSupportedCipherSuites();

    public abstract String[] getSupportedProtocols();

    public abstract boolean getUseClientMode();

    public abstract boolean getWantClientAuth();

    public abstract boolean isInboundDone();

    public abstract boolean isOutboundDone();

    public abstract void setEnabledCipherSuites(String[] var1);

    public abstract void setEnabledProtocols(String[] var1);

    public abstract void setEnableSessionCreation(boolean var1);

    public abstract void setNeedClientAuth(boolean var1);

    public abstract void setUseClientMode(boolean var1);

    public abstract void setWantClientAuth(boolean var1);

    public abstract SSLEngineResult unwrap(ByteBuffer var1, ByteBuffer[] var2, int var3, int var4) throws SSLException;

    public abstract SSLEngineResult wrap(ByteBuffer[] var1, int var2, int var3, ByteBuffer var4) throws SSLException;

    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.unwrap(src, new ByteBuffer[]{dst}, 0, 1);
    }

    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        if (dsts == null) {
            throw new IllegalArgumentException("Byte buffer array dsts is null");
        }
        return this.unwrap(src, dsts, 0, dsts.length);
    }

    public SSLEngineResult wrap(ByteBuffer[] srcs, ByteBuffer dst) throws SSLException {
        if (srcs == null) {
            throw new IllegalArgumentException("Byte buffer array srcs is null");
        }
        return this.wrap(srcs, 0, srcs.length, dst);
    }

    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.wrap(new ByteBuffer[]{src}, 0, 1, dst);
    }

    public SSLParameters getSSLParameters() {
        SSLParameters p = new SSLParameters();
        p.setCipherSuites(this.getEnabledCipherSuites());
        p.setProtocols(this.getEnabledProtocols());
        p.setNeedClientAuth(this.getNeedClientAuth());
        p.setWantClientAuth(this.getWantClientAuth());
        return p;
    }

    public void setSSLParameters(SSLParameters p) {
        String[] protocols;
        String[] cipherSuites = p.getCipherSuites();
        if (cipherSuites != null) {
            this.setEnabledCipherSuites(cipherSuites);
        }
        if ((protocols = p.getProtocols()) != null) {
            this.setEnabledProtocols(protocols);
        }
        if (p.getNeedClientAuth()) {
            this.setNeedClientAuth(true);
        } else if (p.getWantClientAuth()) {
            this.setWantClientAuth(true);
        } else {
            this.setWantClientAuth(false);
        }
    }
}

