/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;

public abstract class Certificate
implements Serializable {
    private static final long serialVersionUID = -3585440601605666277L;
    private final String type;

    protected Certificate(String type) {
        this.type = type;
    }

    public final String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Certificate) {
            try {
                return Arrays.equals(this.getEncoded(), ((Certificate)other).getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            byte[] encoded = this.getEncoded();
            int hash = 0;
            for (int i = 0; i < encoded.length; ++i) {
                hash += i * encoded[i];
            }
            return hash;
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.getType(), this.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new NotSerializableException("Could not create serialization object: " + e);
        }
    }

    protected static class CertificateRep
    implements Serializable {
        private static final long serialVersionUID = -8563758940495660020L;
        private final String type;
        private final byte[] data;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("type", String.class), new ObjectStreamField("data", byte[].class, true)};

        protected CertificateRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory cf = CertificateFactory.getInstance(this.type);
                return cf.generateCertificate(new ByteArrayInputStream(this.data));
            }
            catch (Throwable t) {
                throw new NotSerializableException("Could not resolve certificate: " + t);
            }
        }
    }
}

