/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.fortress.SecurityAccess;
import org.apache.harmony.security.fortress.Services;

public final class Security {
    private static final Properties secprops = new Properties();

    private Security() {
    }

    private static void registerDefaultProviders() {
        secprops.put("security.provider.1", "com.android.org.conscrypt.OpenSSLProvider");
        secprops.put("security.provider.2", "org.apache.harmony.security.provider.cert.DRLCertFactory");
        secprops.put("security.provider.3", "com.android.org.bouncycastle.jce.provider.BouncyCastleProvider");
        secprops.put("security.provider.4", "org.apache.harmony.security.provider.crypto.CryptoProvider");
        secprops.put("security.provider.5", "com.android.org.conscrypt.JSSEProvider");
    }

    @Deprecated
    public static String getAlgorithmProperty(String algName, String propName) {
        Provider[] providers;
        if (algName == null || propName == null) {
            return null;
        }
        String prop = "Alg." + propName + "." + algName;
        for (Provider provider : providers = Security.getProviders()) {
            Enumeration<?> e = provider.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                if (!propertyName.equalsIgnoreCase(prop)) continue;
                return provider.getProperty(propertyName);
            }
        }
        return null;
    }

    public static synchronized int insertProviderAt(Provider provider, int position) {
        if (Security.getProvider(provider.getName()) != null) {
            return -1;
        }
        int result = Services.insertProviderAt(provider, position);
        Security.renumProviders();
        return result;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, 0);
    }

    public static synchronized void removeProvider(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        Provider p = Security.getProvider(name);
        if (p == null) {
            return;
        }
        Services.removeProvider(p.getProviderNumber());
        Security.renumProviders();
        p.setProviderNumber(-1);
    }

    public static synchronized Provider[] getProviders() {
        return Services.getProviders();
    }

    public static synchronized Provider getProvider(String name) {
        return Services.getProvider(name);
    }

    public static Provider[] getProviders(String filter) {
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        if (filter.length() == 0) {
            throw new InvalidParameterException();
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        int i = filter.indexOf(58);
        if (i == filter.length() - 1 || i == 0) {
            throw new InvalidParameterException();
        }
        if (i < 1) {
            hm.put(filter, "");
        } else {
            hm.put(filter.substring(0, i), filter.substring(i + 1));
        }
        return Security.getProviders(hm);
    }

    public static synchronized Provider[] getProviders(Map<String, String> filter) {
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        if (filter.isEmpty()) {
            return null;
        }
        List<Provider> result = Services.getProvidersList();
        Set<Map.Entry<String, String>> keys2 = filter.entrySet();
        block2: for (Map.Entry<String, String> entry : keys2) {
            String key = entry.getKey();
            String val = entry.getValue();
            String attribute = null;
            int i = key.indexOf(32);
            int j = key.indexOf(46);
            if (j == -1) {
                throw new InvalidParameterException();
            }
            if (i == -1) {
                if (val.length() != 0) {
                    throw new InvalidParameterException();
                }
            } else {
                if (val.length() == 0) {
                    throw new InvalidParameterException();
                }
                attribute = key.substring(i + 1);
                if (attribute.trim().length() == 0) {
                    throw new InvalidParameterException();
                }
                key = key.substring(0, i);
            }
            String serv = key.substring(0, j);
            String alg = key.substring(j + 1);
            if (serv.length() == 0 || alg.length() == 0) {
                throw new InvalidParameterException();
            }
            for (int k = 0; k < result.size(); ++k) {
                Provider p;
                try {
                    p = result.get(k);
                }
                catch (IndexOutOfBoundsException e) {
                    continue block2;
                }
                if (p.implementsAlg(serv, alg, attribute, val)) continue;
                result.remove(p);
                --k;
            }
        }
        if (result.size() > 0) {
            return result.toArray(new Provider[result.size()]);
        }
        return null;
    }

    public static String getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String property = secprops.getProperty(key);
        if (property != null) {
            property = property.trim();
        }
        return property;
    }

    public static void setProperty(String key, String value) {
        secprops.put(key, value);
    }

    public static Set<String> getAlgorithms(String serviceName) {
        HashSet<String> result = new HashSet<String>();
        if (serviceName == null) {
            return result;
        }
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                if (!service.getType().equalsIgnoreCase(serviceName)) continue;
                result.add(service.getAlgorithm());
            }
        }
        return result;
    }

    private static void renumProviders() {
        Provider[] p = Services.getProviders();
        for (int i = 0; i < p.length; ++i) {
            p[i].setProviderNumber(i + 1);
        }
    }

    static {
        boolean loaded = false;
        try {
            InputStream configStream = Security.class.getResourceAsStream("security.properties");
            BufferedInputStream input = new BufferedInputStream(configStream);
            secprops.load(input);
            loaded = true;
            configStream.close();
        }
        catch (Exception ex) {
            System.logE("Could not load 'security.properties'", ex);
        }
        if (!loaded) {
            Security.registerDefaultProviders();
        }
        Engine.door = new SecurityDoor();
    }

    private static class SecurityDoor
    implements SecurityAccess {
        private SecurityDoor() {
        }

        @Override
        public void renumProviders() {
            Security.renumProviders();
        }

        @Override
        public List<String> getAliases(Provider.Service s) {
            return s.getAliases();
        }

        @Override
        public Provider.Service getService(Provider p, String type) {
            return p.getService(type);
        }
    }
}

