/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInt;
import java.math.BigInteger;

class Multiplication {
    static final int[] tenPows;
    static final int[] fivePows;
    static final BigInteger[] bigTenPows;
    static final BigInteger[] bigFivePows;

    private Multiplication() {
    }

    static BigInteger multiplyByPositiveInt(BigInteger val, int factor) {
        BigInt bi = val.getBigInt().copy();
        bi.multiplyByPositiveInt(factor);
        return new BigInteger(bi);
    }

    static BigInteger multiplyByTenPow(BigInteger val, long exp) {
        return exp < (long)tenPows.length ? Multiplication.multiplyByPositiveInt(val, tenPows[(int)exp]) : val.multiply(Multiplication.powerOf10(exp));
    }

    static BigInteger powerOf10(long exp) {
        long longExp;
        BigInteger powerOfFive;
        int intExp = (int)exp;
        if (exp < (long)bigTenPows.length) {
            return bigTenPows[intExp];
        }
        if (exp <= 50L) {
            return BigInteger.TEN.pow(intExp);
        }
        if (exp <= 1000L) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        long byteArraySize = 1L + (long)((double)exp / 2.4082399653118496);
        if (byteArraySize > 65536L && byteArraySize > Runtime.getRuntime().freeMemory()) {
            throw new ArithmeticException();
        }
        if (exp <= Integer.MAX_VALUE) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        BigInteger res = powerOfFive = bigFivePows[1].pow(Integer.MAX_VALUE);
        intExp = (int)(exp % Integer.MAX_VALUE);
        for (longExp = exp - Integer.MAX_VALUE; longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
            res = res.multiply(powerOfFive);
        }
        res = res.multiply(bigFivePows[1].pow(intExp));
        res = res.shiftLeft(Integer.MAX_VALUE);
        for (longExp = exp - Integer.MAX_VALUE; longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
            res = res.shiftLeft(Integer.MAX_VALUE);
        }
        res = res.shiftLeft(intExp);
        return res;
    }

    static BigInteger multiplyByFivePow(BigInteger val, int exp) {
        if (exp < fivePows.length) {
            return Multiplication.multiplyByPositiveInt(val, fivePows[exp]);
        }
        if (exp < bigFivePows.length) {
            return val.multiply(bigFivePows[exp]);
        }
        return val.multiply(bigFivePows[1].pow(exp));
    }

    static {
        int i;
        tenPows = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        fivePows = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        bigTenPows = new BigInteger[32];
        bigFivePows = new BigInteger[32];
        long fivePow = 1L;
        for (i = 0; i <= 18; ++i) {
            Multiplication.bigFivePows[i] = BigInteger.valueOf(fivePow);
            Multiplication.bigTenPows[i] = BigInteger.valueOf(fivePow << i);
            fivePow *= 5L;
        }
        while (i < bigTenPows.length) {
            Multiplication.bigFivePows[i] = bigFivePows[i - 1].multiply(bigFivePows[1]);
            Multiplication.bigTenPows[i] = bigTenPows[i - 1].multiply(BigInteger.TEN);
            ++i;
        }
    }
}

