/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.bugvm.rt.VM;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Comparator;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.Types;

public final class Field
extends AccessibleObject
implements Member {
    public static final Comparator<Field> ORDER_BY_NAME_AND_DECLARING_CLASS = new Comparator<Field>(){

        @Override
        public int compare(Field a, Field b) {
            int comparison = a.name.compareTo(b.name);
            if (comparison != 0) {
                return comparison;
            }
            return a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
        }
    };
    private final long field;
    private int modifiers = -1;
    private Class<?> declaringClass;
    private String name;
    private Class<?> type;
    private Annotation[] declaredAnnotations;
    private Type genericType;
    private volatile boolean genericTypesAreInitialized = false;

    Field(long field) {
        this.field = field;
    }

    Field(Field orig) {
        this.field = orig.field;
        this.modifiers = orig.modifiers;
        this.declaringClass = orig.declaringClass;
        this.name = orig.name;
        this.type = orig.type;
        this.genericType = orig.genericType;
        this.genericTypesAreInitialized = orig.genericTypesAreInitialized;
        this.declaredAnnotations = orig.declaredAnnotations;
        if (orig.flag) {
            this.flag = true;
        }
    }

    private synchronized void initGenericType() {
        if (!this.genericTypesAreInitialized) {
            String signatureAttribute = this.getSignatureAttribute();
            GenericSignatureParser parser = new GenericSignatureParser(this.getDeclaringClass().getClassLoader());
            parser.parseForField(this.getDeclaringClass(), signatureAttribute);
            this.genericType = parser.fieldType;
            if (this.genericType == null) {
                this.genericType = this.getType();
            }
            this.genericTypesAreInitialized = true;
        }
    }

    @Override
    protected String getSignatureAttribute() {
        return Field.getSignatureAttribute(this.field);
    }

    private static final native String getSignatureAttribute(long var0);

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String toGenericString() {
        StringBuilder sb = new StringBuilder(80);
        int modifier = this.getModifiers();
        if (modifier != 0) {
            sb.append(Modifier.toString(modifier)).append(' ');
        }
        this.appendGenericType(sb, this.getGenericType());
        sb.append(' ');
        sb.append(this.getDeclaringClass().getName()).append('.').append(this.getName());
        return sb.toString();
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public Type getGenericType() {
        this.initGenericType();
        return Types.getType(this.genericType);
    }

    @Override
    protected Annotation[] getDeclaredAnnotations(boolean copy) {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = Field.getDeclaredAnnotations(this.field);
        }
        return copy ? (Annotation[])this.declaredAnnotations.clone() : this.declaredAnnotations;
    }

    private static final native Annotation[] getDeclaredAnnotations(long var0);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field rhs = (Field)object;
        return this.getDeclaringClass().equals(rhs.getDeclaringClass()) && this.getType().equals(rhs.getType()) && this.getName().equals(rhs.getName());
    }

    private void checkAccess(Object receiver, boolean setter) throws IllegalAccessException {
        if (!this.flag) {
            int mod = this.getModifiers();
            if (setter && (mod & 0x10) > 0) {
                throw new IllegalAccessException("Cannot set final field");
            }
            if (!Field.checkAccessibleFast(this)) {
                Class<?> caller = VM.getStackClasses(1, 1)[0];
                if (!Field.checkAccessible(caller, this)) {
                    throw new IllegalAccessException(String.format("Attempt to access field %s.%s from class %s", this.getDeclaringClass().getName(), this.getName(), caller.getName()));
                }
                if ((this.getModifiers() & 4) > 0) {
                    boolean isInstance = caller.isInstance(receiver);
                    boolean samePackage = Field.isSamePackage(this.getDeclaringClass(), caller);
                    if (!isInstance && !samePackage) {
                        throw new IllegalAccessException(String.format("Attempt to access protected field %s.%s from class %s", this.getDeclaringClass().getName(), this.getName(), caller.getName()));
                    }
                }
            }
        }
    }

    private void checkReceiver(Object object) {
        int mod = this.getModifiers();
        if ((mod & 8) == 0) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!this.getDeclaringClass().isInstance(object)) {
                throw new IllegalArgumentException("Receiver is not compatible with declaring class");
            }
        }
    }

    private void throwGetConversionException(Class<?> fieldType, Class<?> expectedType) {
        throw new IllegalArgumentException("Cannot convert " + fieldType + " field " + this.getDeclaringClass().getName() + "." + this.getName() + " to " + expectedType);
    }

    private void throwSetConversionException(Class<?> fieldType, Class<?> valueType) {
        throw new IllegalArgumentException("Cannot set " + fieldType + " field " + this.getDeclaringClass().getName() + "." + this.getName() + " to " + valueType);
    }

    private double getDouble(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Double.TYPE) {
            return Field.getD(object, this.field);
        }
        return this.getFloat(object, fieldType, expectedType);
    }

    private float getFloat(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Float.TYPE) {
            return Field.getF(object, this.field);
        }
        return this.getLong(object, fieldType, expectedType);
    }

    private long getLong(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Long.TYPE) {
            return Field.getJ(object, this.field);
        }
        return this.getInt(object, fieldType, expectedType);
    }

    private int getInt(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Integer.TYPE) {
            return Field.getI(object, this.field);
        }
        if (fieldType == Character.TYPE) {
            return Field.getC(object, this.field);
        }
        return this.getShort(object, fieldType, expectedType);
    }

    private char getChar(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Character.TYPE) {
            return Field.getC(object, this.field);
        }
        this.throwGetConversionException(fieldType, expectedType);
        return '\u0000';
    }

    private short getShort(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Short.TYPE) {
            return Field.getS(object, this.field);
        }
        return this.getByte(object, fieldType, expectedType);
    }

    private byte getByte(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Byte.TYPE) {
            return Field.getB(object, this.field);
        }
        this.throwGetConversionException(fieldType, expectedType);
        return 0;
    }

    private boolean getBoolean(Object object, Class<?> fieldType, Class<?> expectedType) {
        if (fieldType == Boolean.TYPE) {
            return Field.getZ(object, this.field);
        }
        this.throwGetConversionException(fieldType, expectedType);
        return false;
    }

    private void setDouble(Object object, double value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Double.TYPE) {
            Field.setD(object, this.field, value);
        } else {
            this.throwSetConversionException(fieldType, valueType);
        }
    }

    private void setFloat(Object object, float value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Float.TYPE) {
            Field.setF(object, this.field, value);
        } else {
            this.setDouble(object, value, fieldType, valueType);
        }
    }

    private void setLong(Object object, long value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Long.TYPE) {
            Field.setJ(object, this.field, value);
        } else {
            this.setFloat(object, value, fieldType, valueType);
        }
    }

    private void setInt(Object object, int value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Integer.TYPE) {
            Field.setI(object, this.field, value);
        } else {
            this.setLong(object, value, fieldType, valueType);
        }
    }

    private void setChar(Object object, char value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Character.TYPE) {
            Field.setC(object, this.field, value);
        } else {
            this.setInt(object, value, fieldType, valueType);
        }
    }

    private void setShort(Object object, short value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Short.TYPE) {
            Field.setS(object, this.field, value);
        } else {
            this.setInt(object, value, fieldType, valueType);
        }
    }

    private void setByte(Object object, byte value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Byte.TYPE) {
            Field.setB(object, this.field, value);
        } else {
            this.setShort(object, value, fieldType, valueType);
        }
    }

    private void setBoolean(Object object, boolean value, Class<?> fieldType, Class<?> valueType) {
        if (fieldType == Boolean.TYPE) {
            Field.setZ(object, this.field, value);
        } else {
            this.throwSetConversionException(fieldType, valueType);
        }
    }

    public Object get(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        Class<?> type = this.getType();
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Field.getZ(object, this.field);
            }
            if (type == Byte.TYPE) {
                return Field.getB(object, this.field);
            }
            if (type == Short.TYPE) {
                return Field.getS(object, this.field);
            }
            if (type == Character.TYPE) {
                return Character.valueOf(Field.getC(object, this.field));
            }
            if (type == Integer.TYPE) {
                return Field.getI(object, this.field);
            }
            if (type == Long.TYPE) {
                return Field.getJ(object, this.field);
            }
            if (type == Float.TYPE) {
                return Float.valueOf(Field.getF(object, this.field));
            }
            if (type == Double.TYPE) {
                return Field.getD(object, this.field);
            }
        }
        return Field.getL(object, this.field);
    }

    public boolean getBoolean(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getBoolean(object, this.getType(), Boolean.TYPE);
    }

    public byte getByte(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getByte(object, this.getType(), Byte.TYPE);
    }

    public char getChar(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getChar(object, this.getType(), Character.TYPE);
    }

    @Override
    public Class<?> getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = Field.getDeclaringClass(this.field);
        }
        return this.declaringClass;
    }

    static native <T> Class<T> getDeclaringClass(long var0);

    public double getDouble(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getDouble(object, this.getType(), Double.TYPE);
    }

    public float getFloat(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getFloat(object, this.getType(), Float.TYPE);
    }

    public int getInt(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getInt(object, this.getType(), Integer.TYPE);
    }

    public long getLong(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getLong(object, this.getType(), Long.TYPE);
    }

    @Override
    public int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = Field.getModifiers(this.field);
        }
        return this.modifiers;
    }

    private static native int getModifiers(long var0);

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = Field.getName(this.field);
        }
        return this.name;
    }

    private static native String getName(long var0);

    public short getShort(Object object) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, false);
        this.checkReceiver(object);
        return this.getShort(object, this.getType(), Short.TYPE);
    }

    private String getSignature() {
        return this.getSignature(this.type);
    }

    public Class<?> getType() {
        if (this.type == null) {
            this.type = Field.getType(this.field);
        }
        return this.type;
    }

    private static native Class<?> getType(long var0);

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDeclaringClass().getName().hashCode();
    }

    public void set(Object object, Object value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        Class<?> type = this.getType();
        if (type.isPrimitive()) {
            if (value == null) {
                this.throwSetConversionException(type, null);
            }
            if (value instanceof Boolean) {
                this.setBoolean(object, (Boolean)value, type, Boolean.TYPE);
            } else if (value instanceof Byte) {
                this.setByte(object, (Byte)value, type, Byte.TYPE);
            } else if (value instanceof Short) {
                this.setShort(object, (Short)value, type, Short.TYPE);
            } else if (value instanceof Character) {
                this.setChar(object, ((Character)value).charValue(), type, Character.TYPE);
            } else if (value instanceof Integer) {
                this.setInt(object, (Integer)value, type, Integer.TYPE);
            } else if (value instanceof Long) {
                this.setLong(object, (Long)value, type, Long.TYPE);
            } else if (value instanceof Float) {
                this.setFloat(object, ((Float)value).floatValue(), type, Float.TYPE);
            } else if (value instanceof Double) {
                this.setDouble(object, (Double)value, type, Double.TYPE);
            } else {
                this.throwSetConversionException(type, value.getClass());
            }
        } else {
            if (value != null && !this.getType().isInstance(value)) {
                throw new IllegalArgumentException(String.format("Can not set %s field %s.%s to %s", this.getType().getName(), this.getDeclaringClass().getName(), this.getName(), value.getClass().getName()));
            }
            Field.setL(object, this.field, value);
        }
    }

    public void setBoolean(Object object, boolean value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setBoolean(object, value, this.getType(), Boolean.TYPE);
    }

    public void setByte(Object object, byte value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setByte(object, value, this.getType(), Byte.TYPE);
    }

    public void setChar(Object object, char value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setChar(object, value, this.getType(), Character.TYPE);
    }

    public void setDouble(Object object, double value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setDouble(object, value, this.getType(), Double.TYPE);
    }

    public void setFloat(Object object, float value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setFloat(object, value, this.getType(), Float.TYPE);
    }

    public void setInt(Object object, int value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setInt(object, value, this.getType(), Integer.TYPE);
    }

    public void setLong(Object object, long value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setLong(object, value, this.getType(), Long.TYPE);
    }

    public void setShort(Object object, short value) throws IllegalAccessException, IllegalArgumentException {
        this.checkAccess(object, true);
        this.checkReceiver(object);
        this.setShort(object, value, this.getType(), Short.TYPE);
    }

    public String toString() {
        Class<?> type = this.getType();
        Class<?> declaringClass = this.getDeclaringClass();
        String name = this.getName();
        StringBuilder result = new StringBuilder(Modifier.toString(this.getModifiers()));
        if (result.length() != 0) {
            result.append(' ');
        }
        this.appendTypeName(result, type);
        result.append(' ');
        this.appendTypeName(result, declaringClass);
        result.append('.');
        result.append(name);
        return result.toString();
    }

    private static native boolean getZ(Object var0, long var1);

    private static native byte getB(Object var0, long var1);

    private static native char getC(Object var0, long var1);

    private static native short getS(Object var0, long var1);

    private static native int getI(Object var0, long var1);

    private static native long getJ(Object var0, long var1);

    private static native float getF(Object var0, long var1);

    private static native double getD(Object var0, long var1);

    private static native Object getL(Object var0, long var1);

    private static native void setZ(Object var0, long var1, boolean var3);

    private static native void setB(Object var0, long var1, byte var3);

    private static native void setC(Object var0, long var1, char var3);

    private static native void setS(Object var0, long var1, short var3);

    private static native void setI(Object var0, long var1, int var3);

    private static native void setJ(Object var0, long var1, long var3);

    private static native void setF(Object var0, long var1, float var3);

    private static native void setD(Object var0, long var1, double var3);

    private static native void setL(Object var0, long var1, Object var3);
}

