/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import libcore.util.EmptyArray;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String detailMessage;
    private Throwable cause = this;
    private List<Throwable> suppressedExceptions = Collections.emptyList();
    private volatile transient long stackState;
    private StackTraceElement[] stackTrace;

    public Throwable() {
        this.stackTrace = EmptyArray.STACK_TRACE_ELEMENT;
        this.fillInStackTrace();
    }

    public Throwable(String detailMessage) {
        this.detailMessage = detailMessage;
        this.stackTrace = EmptyArray.STACK_TRACE_ELEMENT;
        this.fillInStackTrace();
    }

    public Throwable(String detailMessage, Throwable cause) {
        this.detailMessage = detailMessage;
        this.cause = cause;
        this.stackTrace = EmptyArray.STACK_TRACE_ELEMENT;
        this.fillInStackTrace();
    }

    public Throwable(Throwable cause) {
        this.detailMessage = cause == null ? null : cause.toString();
        this.cause = cause;
        this.stackTrace = EmptyArray.STACK_TRACE_ELEMENT;
        this.fillInStackTrace();
    }

    protected Throwable(String detailMessage, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.detailMessage = detailMessage;
        this.cause = cause;
        if (!enableSuppression) {
            this.suppressedExceptions = null;
        }
        if (writableStackTrace) {
            this.stackTrace = EmptyArray.STACK_TRACE_ELEMENT;
            this.fillInStackTrace();
        } else {
            this.stackTrace = null;
        }
    }

    static void init(Throwable t, long stackState) {
        t.stackState = stackState;
        t.stackTrace = EmptyArray.STACK_TRACE_ELEMENT;
        t.suppressedExceptions = Collections.EMPTY_LIST;
        t.cause = t;
    }

    public Throwable fillInStackTrace() {
        if (this.stackTrace == null) {
            return this;
        }
        this.stackState = Throwable.nativeFillInStackTrace();
        this.stackTrace = EmptyArray.STACK_TRACE_ELEMENT;
        return this;
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getInternalStackTrace().clone();
    }

    public void setStackTrace(StackTraceElement[] trace) {
        if (this.stackTrace == null) {
            return;
        }
        StackTraceElement[] newTrace = (StackTraceElement[])trace.clone();
        for (int i = 0; i < newTrace.length; ++i) {
            if (newTrace[i] != null) continue;
            throw new NullPointerException("trace[" + i + "] == null");
        }
        this.stackTrace = newTrace;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] currentStack, StackTraceElement[] parentStack) {
        StackTraceElement parentFrame;
        int duplicates = 0;
        int parentIndex = parentStack.length;
        int i = currentStack.length;
        while (--i >= 0 && --parentIndex >= 0 && (parentFrame = parentStack[parentIndex]).equals(currentStack[i])) {
            ++duplicates;
        }
        return duplicates;
    }

    private StackTraceElement[] getInternalStackTrace() {
        if (this.stackTrace == EmptyArray.STACK_TRACE_ELEMENT) {
            this.stackTrace = Throwable.nativeGetStackTrace(this.stackState);
            this.stackState = 0L;
            return this.stackTrace;
        }
        if (this.stackTrace == null) {
            return EmptyArray.STACK_TRACE_ELEMENT;
        }
        return this.stackTrace;
    }

    public void printStackTrace(PrintStream err) {
        try {
            this.printStackTrace(err, "", null);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public void printStackTrace(PrintWriter err) {
        try {
            this.printStackTrace(err, "", null);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    private void printStackTrace(Appendable err, String indent, StackTraceElement[] parentStack) throws IOException {
        Throwable cause;
        err.append(this.toString());
        err.append("\n");
        StackTraceElement[] stack = this.getInternalStackTrace();
        if (stack != null) {
            int duplicates = parentStack != null ? Throwable.countDuplicates(stack, parentStack) : 0;
            for (int i = 0; i < stack.length - duplicates; ++i) {
                err.append(indent);
                err.append("\tat ");
                err.append(stack[i].toString());
                err.append("\n");
            }
            if (duplicates > 0) {
                err.append(indent);
                err.append("\t... ");
                err.append(Integer.toString(duplicates));
                err.append(" more\n");
            }
        }
        if (this.suppressedExceptions != null) {
            for (Throwable throwable : this.suppressedExceptions) {
                err.append(indent);
                err.append("\tSuppressed: ");
                throwable.printStackTrace(err, indent + "\t", stack);
            }
        }
        if ((cause = this.getCause()) != null) {
            err.append(indent);
            err.append("Caused by: ");
            cause.printStackTrace(err, indent, stack);
        }
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        String name = this.getClass().getName();
        if (msg == null) {
            return name;
        }
        return name + ": " + msg;
    }

    public Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException("Cause already initialized");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("throwable == this");
        }
        this.cause = throwable;
        return this;
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    public final void addSuppressed(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException("throwable == this");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable == null");
        }
        if (this.suppressedExceptions != null) {
            if (this.suppressedExceptions.isEmpty()) {
                this.suppressedExceptions = new ArrayList<Throwable>(1);
            }
            this.suppressedExceptions.add(throwable);
        }
    }

    public final Throwable[] getSuppressed() {
        return this.suppressedExceptions != null && !this.suppressedExceptions.isEmpty() ? this.suppressedExceptions.toArray(new Throwable[this.suppressedExceptions.size()]) : EmptyArray.THROWABLE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getInternalStackTrace();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.suppressedExceptions != null) {
            this.suppressedExceptions = new ArrayList<Throwable>(this.suppressedExceptions);
        }
    }

    private static native long nativeFillInStackTrace();

    private static native StackTraceElement[] nativeGetStackTrace(long var0);
}

