/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadLocal<T> {
    private final Reference<ThreadLocal<T>> reference = new WeakReference<ThreadLocal>(this);
    private static AtomicInteger hashCounter = new AtomicInteger(0);
    private final int hash = hashCounter.getAndAdd(-1013904242);

    public T get() {
        Thread currentThread = Thread.currentThread();
        Values values2 = this.values(currentThread);
        if (values2 != null) {
            int index;
            Object[] table = values2.table;
            if (this.reference == table[index = this.hash & values2.mask]) {
                return (T)table[index + 1];
            }
        } else {
            values2 = this.initializeValues(currentThread);
        }
        return (T)values2.getAfterMiss(this);
    }

    protected T initialValue() {
        return null;
    }

    public void set(T value) {
        Thread currentThread = Thread.currentThread();
        Values values2 = this.values(currentThread);
        if (values2 == null) {
            values2 = this.initializeValues(currentThread);
        }
        values2.put(this, value);
    }

    public void remove() {
        Thread currentThread = Thread.currentThread();
        Values values2 = this.values(currentThread);
        if (values2 != null) {
            values2.remove(this);
        }
    }

    Values initializeValues(Thread current) {
        current.localValues = new Values();
        return current.localValues;
    }

    Values values(Thread current) {
        return current.localValues;
    }

    static class Values {
        private static final int INITIAL_SIZE = 16;
        private static final Object TOMBSTONE = new Object();
        private Object[] table;
        private int mask;
        private int size;
        private int tombstones;
        private int maximumLoad;
        private int clean;

        Values() {
            this.initializeTable(16);
            this.size = 0;
            this.tombstones = 0;
        }

        Values(Values fromParent) {
            this.table = (Object[])fromParent.table.clone();
            this.mask = fromParent.mask;
            this.size = fromParent.size;
            this.tombstones = fromParent.tombstones;
            this.maximumLoad = fromParent.maximumLoad;
            this.clean = fromParent.clean;
            this.inheritValues(fromParent);
        }

        private void inheritValues(Values fromParent) {
            Object[] table = this.table;
            for (int i = table.length - 2; i >= 0; i -= 2) {
                Object k = table[i];
                if (k == null || k == TOMBSTONE) continue;
                Reference reference = (Reference)k;
                InheritableThreadLocal key = (InheritableThreadLocal)reference.get();
                if (key != null) {
                    table[i + 1] = key.childValue(fromParent.table[i + 1]);
                    continue;
                }
                table[i] = TOMBSTONE;
                table[i + 1] = null;
                fromParent.table[i] = TOMBSTONE;
                fromParent.table[i + 1] = null;
                ++this.tombstones;
                ++fromParent.tombstones;
                --this.size;
                --fromParent.size;
            }
        }

        private void initializeTable(int capacity) {
            this.table = new Object[capacity * 2];
            this.mask = this.table.length - 1;
            this.clean = 0;
            this.maximumLoad = capacity * 2 / 3;
        }

        private void cleanUp() {
            if (this.rehash()) {
                return;
            }
            if (this.size == 0) {
                return;
            }
            int index = this.clean;
            Object[] table = this.table;
            for (int counter = table.length; counter > 0; counter >>= 1) {
                Reference reference;
                Object k = table[index];
                if (k != TOMBSTONE && k != null && (reference = (Reference)k).get() == null) {
                    table[index] = TOMBSTONE;
                    table[index + 1] = null;
                    ++this.tombstones;
                    --this.size;
                }
                index = this.next(index);
            }
            this.clean = index;
        }

        private boolean rehash() {
            int capacity;
            if (this.tombstones + this.size < this.maximumLoad) {
                return false;
            }
            int newCapacity = capacity = this.table.length >> 1;
            if (this.size > capacity >> 1) {
                newCapacity = capacity * 2;
            }
            Object[] oldTable = this.table;
            this.initializeTable(newCapacity);
            this.tombstones = 0;
            if (this.size == 0) {
                return true;
            }
            for (int i = oldTable.length - 2; i >= 0; i -= 2) {
                Object k = oldTable[i];
                if (k == null || k == TOMBSTONE) continue;
                Reference reference = (Reference)k;
                ThreadLocal key = (ThreadLocal)reference.get();
                if (key != null) {
                    this.add(key, oldTable[i + 1]);
                    continue;
                }
                --this.size;
            }
            return true;
        }

        void add(ThreadLocal<?> key, Object value) {
            int index = ((ThreadLocal)key).hash & this.mask;
            while (true) {
                Object k;
                if ((k = this.table[index]) == null) {
                    this.table[index] = ((ThreadLocal)key).reference;
                    this.table[index + 1] = value;
                    return;
                }
                index = this.next(index);
            }
        }

        void put(ThreadLocal<?> key, Object value) {
            this.cleanUp();
            int firstTombstone = -1;
            int index = ((ThreadLocal)key).hash & this.mask;
            while (true) {
                Object k;
                if ((k = this.table[index]) == ((ThreadLocal)key).reference) {
                    this.table[index + 1] = value;
                    return;
                }
                if (k == null) {
                    if (firstTombstone == -1) {
                        this.table[index] = ((ThreadLocal)key).reference;
                        this.table[index + 1] = value;
                        ++this.size;
                        return;
                    }
                    this.table[firstTombstone] = ((ThreadLocal)key).reference;
                    this.table[firstTombstone + 1] = value;
                    --this.tombstones;
                    ++this.size;
                    return;
                }
                if (firstTombstone == -1 && k == TOMBSTONE) {
                    firstTombstone = index;
                }
                index = this.next(index);
            }
        }

        Object getAfterMiss(ThreadLocal<?> key) {
            Object[] table = this.table;
            int index = ((ThreadLocal)key).hash & this.mask;
            if (table[index] == null) {
                Object value = key.initialValue();
                if (this.table == table && table[index] == null) {
                    table[index] = ((ThreadLocal)key).reference;
                    table[index + 1] = value;
                    ++this.size;
                    this.cleanUp();
                    return value;
                }
                this.put(key, value);
                return value;
            }
            int firstTombstone = -1;
            index = this.next(index);
            Object reference;
            while ((reference = table[index]) != ((ThreadLocal)key).reference) {
                if (reference == null) {
                    Object value = key.initialValue();
                    if (this.table == table) {
                        if (firstTombstone > -1 && table[firstTombstone] == TOMBSTONE) {
                            table[firstTombstone] = ((ThreadLocal)key).reference;
                            table[firstTombstone + 1] = value;
                            --this.tombstones;
                            ++this.size;
                            return value;
                        }
                        if (table[index] == null) {
                            table[index] = ((ThreadLocal)key).reference;
                            table[index + 1] = value;
                            ++this.size;
                            this.cleanUp();
                            return value;
                        }
                    }
                    this.put(key, value);
                    return value;
                }
                if (firstTombstone == -1 && reference == TOMBSTONE) {
                    firstTombstone = index;
                }
                index = this.next(index);
            }
            return table[index + 1];
        }

        void remove(ThreadLocal<?> key) {
            this.cleanUp();
            int index = ((ThreadLocal)key).hash & this.mask;
            while (true) {
                Object reference;
                if ((reference = this.table[index]) == ((ThreadLocal)key).reference) {
                    this.table[index] = TOMBSTONE;
                    this.table[index + 1] = null;
                    ++this.tombstones;
                    --this.size;
                    return;
                }
                if (reference == null) {
                    return;
                }
                index = this.next(index);
            }
        }

        private int next(int index) {
            return index + 2 & this.mask;
        }
    }
}

