/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.bugvm.rt.VM;
import dalvik.system.VMRuntime;
import dalvik.system.VMStack;
import java.io.BufferedInputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import libcore.icu.ICU;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.StructPasswd;
import libcore.io.StructUtsname;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static final String lineSeparator;
    private static Properties systemProperties;

    public static void setIn(InputStream newIn) {
        System.setFieldImpl("in", "Ljava/io/InputStream;", newIn);
    }

    public static void setOut(PrintStream newOut) {
        System.setFieldImpl("out", "Ljava/io/PrintStream;", newOut);
    }

    public static void setErr(PrintStream newErr) {
        System.setFieldImpl("err", "Ljava/io/PrintStream;", newErr);
    }

    private System() {
    }

    public static void arraycopy(Object src, int srcPos, Object dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        Class<?> type1 = src.getClass();
        Class<?> type2 = dst.getClass();
        if (!type1.isArray()) {
            throw new ArrayStoreException("source of type " + type1.getName() + " is not an array");
        }
        if (!type2.isArray()) {
            throw new ArrayStoreException("destination of type " + type2.getName() + " is not an array");
        }
        Class<?> componentType1 = type1.getComponentType();
        Class<?> componentType2 = type2.getComponentType();
        if (!componentType1.isPrimitive()) {
            if (componentType2.isPrimitive()) {
                throw new ArrayStoreException(type1.getCanonicalName() + " and " + type2.getCanonicalName() + " are incompatible array types");
            }
            System.arraycopy((Object[])src, srcPos, (Object[])dst, dstPos, length);
        } else {
            if (componentType2 != componentType1) {
                throw new ArrayStoreException(type1.getCanonicalName() + " and " + type2.getCanonicalName() + " are incompatible array types");
            }
            if (componentType1 == Integer.TYPE) {
                System.arraycopy((int[])src, srcPos, (int[])dst, dstPos, length);
            } else if (componentType1 == Byte.TYPE) {
                System.arraycopy((byte[])src, srcPos, (byte[])dst, dstPos, length);
            } else if (componentType1 == Long.TYPE) {
                System.arraycopy((long[])src, srcPos, (long[])dst, dstPos, length);
            } else if (componentType1 == Short.TYPE) {
                System.arraycopy((short[])src, srcPos, (short[])dst, dstPos, length);
            } else if (componentType1 == Character.TYPE) {
                System.arraycopy((char[])src, srcPos, (char[])dst, dstPos, length);
            } else if (componentType1 == Boolean.TYPE) {
                System.arraycopy((boolean[])src, srcPos, (boolean[])dst, dstPos, length);
            } else if (componentType1 == Double.TYPE) {
                System.arraycopy((double[])src, srcPos, (double[])dst, dstPos, length);
            } else if (componentType1 == Float.TYPE) {
                System.arraycopy((float[])src, srcPos, (float[])dst, dstPos, length);
            }
        }
    }

    private static void arraycopyCheckBounds(int srcLength, int srcPos, int dstLength, int dstPos, int length) {
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > srcLength - length || dstPos > dstLength - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + srcLength + " srcPos=" + srcPos + " dst.length=" + dstLength + " dstPos=" + dstPos + " length=" + length);
        }
    }

    private static void arraycopyFast(Object src, int srcPos, Object dst, int dstPos, int length, int logElemSize) {
        if (length > 0) {
            long srcAddr = VM.getArrayValuesAddress(src) + (long)(srcPos << logElemSize);
            long dstAddr = VM.getArrayValuesAddress(dst) + (long)(dstPos << logElemSize);
            if (logElemSize == 0) {
                VM.memmove8(dstAddr, srcAddr, length);
            } else if (logElemSize == 1) {
                VM.memmove16(dstAddr, srcAddr, length);
            } else if (logElemSize == 2) {
                VM.memmove32(dstAddr, srcAddr, length);
            } else if (logElemSize == 3) {
                VM.memmove64(dstAddr, srcAddr, length);
            } else {
                throw new AssertionError();
            }
        }
    }

    private static void arraycopy(Object[] src, int srcPos, Object[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        if (length > 0) {
            int i = 0;
            try {
                if (src != dst || srcPos > dstPos || srcPos + length <= dstPos) {
                    for (i = 0; i < length; ++i) {
                        dst[dstPos + i] = src[srcPos + i];
                    }
                } else {
                    for (i = length - 1; i >= 0; --i) {
                        dst[dstPos + i] = src[srcPos + i];
                    }
                }
            }
            catch (ArrayStoreException e) {
                Class<?> srcElemClass = src[i + srcPos].getClass();
                String srcElemTypeName = srcElemClass.isArray() ? srcElemClass.getCanonicalName() : srcElemClass.getName();
                throw new ArrayStoreException(String.format("source[%d] of type %s cannot be stored in destination array of type %s", i + srcPos, srcElemTypeName, dst.getClass().getCanonicalName()));
            }
        }
    }

    private static void arraycopy(int[] src, int srcPos, int[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 2);
    }

    private static void arraycopy(byte[] src, int srcPos, byte[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 0);
    }

    private static void arraycopy(short[] src, int srcPos, short[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 1);
    }

    private static void arraycopy(long[] src, int srcPos, long[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 3);
    }

    private static void arraycopy(char[] src, int srcPos, char[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 1);
    }

    private static void arraycopy(boolean[] src, int srcPos, boolean[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 0);
    }

    private static void arraycopy(double[] src, int srcPos, double[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 3);
    }

    private static void arraycopy(float[] src, int srcPos, float[] dst, int dstPos, int length) {
        System.arraycopyCheckBounds(src.length, srcPos, dst.length, dstPos, length);
        System.arraycopyFast(src, srcPos, dst, dstPos, length, 2);
    }

    public static native long currentTimeMillis();

    public static native long nanoTime();

    public static void exit(int code) {
        Runtime.getRuntime().exit(code);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static String getenv(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return Libcore.os.getenv(name);
    }

    public static Map<String, String> getenv() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : Libcore.os.environ()) {
            int index = entry.indexOf(61);
            if (index == -1) continue;
            map.put(entry.substring(0, index), entry.substring(index + 1));
        }
        return new SystemEnvironment(map);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    public static Properties getProperties() {
        if (systemProperties == null) {
            System.initSystemProperties();
        }
        return systemProperties;
    }

    private static void initSystemProperties() {
        String user;
        String home;
        VMRuntime runtime = VMRuntime.getRuntime();
        Properties p = new Properties();
        String projectUrl = "https://bugvm.com";
        String projectName = "BugVM";
        p.put("java.boot.class.path", runtime.bootClassPath());
        p.put("java.class.path", runtime.classPath());
        p.put("java.class.version", "50.0");
        p.put("java.compiler", "");
        p.put("java.ext.dirs", "");
        p.put("java.version", "0");
        p.put("java.home", VM.resourcesPath());
        String tmpdir = System.getenv("TMPDIR");
        p.put("java.io.tmpdir", tmpdir != null ? tmpdir : "/tmp");
        String ldLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (ldLibraryPath != null) {
            p.put("java.library.path", ldLibraryPath);
        }
        p.put("java.specification.name", "BugVM Core Library");
        p.put("java.specification.vendor", projectName);
        p.put("java.specification.version", "0.9");
        p.put("java.vendor", projectName);
        p.put("java.vendor.url", projectUrl);
        p.put("java.vm.name", "BugVM");
        p.put("java.vm.specification.name", "BugVM Virtual Machine Specification");
        p.put("java.vm.specification.vendor", projectName);
        p.put("java.vm.specification.version", "0.9");
        p.put("java.vm.vendor", projectName);
        p.put("java.vm.version", "0.0.0");
        p.put("file.separator", "/");
        p.put("line.separator", "\n");
        p.put("path.separator", ":");
        p.put("java.runtime.name", "BugVM Runtime");
        p.put("java.runtime.version", "0.9");
        p.put("java.vm.vendor.url", projectUrl);
        p.put("file.encoding", "UTF-8");
        p.put("user.language", "en");
        p.put("user.region", "CA");
        try {
            StructPasswd passwd = Libcore.os.getpwuid(Libcore.os.getuid());
            p.put("user.home", passwd.pw_dir);
            p.put("user.name", passwd.pw_name);
        }
        catch (ErrnoException exception) {
            home = System.getenv("HOME");
            user = System.getenv("USER");
            p.put("user.home", home != null ? home : "");
            p.put("user.name", user != null ? user : "");
        }
        StructUtsname info = Libcore.os.uname();
        p.put("os.arch", info.machine);
        p.put("os.name", info.sysname);
        p.put("os.version", info.release);
        p.put("android.icu.library.version", ICU.getIcuVersion());
        p.put("android.icu.unicode.version", ICU.getUnicodeVersion());
        p.put("android.icu.cldr.version", ICU.getCldrVersion());
        System.parsePropertyAssignments(p, System.specialProperties());
        System.parsePropertyAssignments(p, System.bugvmSpecialProperties());
        if (p.getProperty("os.name").contains("iOS")) {
            home = System.getenv("HOME");
            user = System.getenv("USER");
            p.put("user.home", home != null ? home : "");
            p.put("user.dir", home != null ? home : "/");
            p.put("user.name", user != null ? user : "mobile");
        }
        System.parsePropertyAssignments(p, runtime.properties());
        systemProperties = p;
    }

    private static native String[] specialProperties();

    private static native String[] bugvmSpecialProperties();

    private static void parsePropertyAssignments(Properties p, String[] assignments) {
        for (String assignment : assignments) {
            int split = assignment.indexOf(61);
            String key = assignment.substring(0, split);
            String value = assignment.substring(split + 1);
            p.put(key, value);
        }
    }

    public static String getProperty(String propertyName) {
        return System.getProperty(propertyName, null);
    }

    public static String getProperty(String name, String defaultValue) {
        System.checkPropertyName(name);
        return System.getProperties().getProperty(name, defaultValue);
    }

    public static String setProperty(String name, String value) {
        System.checkPropertyName(name);
        return (String)System.getProperties().setProperty(name, value);
    }

    public static String clearProperty(String name) {
        System.checkPropertyName(name);
        return (String)System.getProperties().remove(name);
    }

    private static void checkPropertyName(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
    }

    public static Console console() {
        return Console.getConsole();
    }

    public static SecurityManager getSecurityManager() {
        return null;
    }

    public static native int identityHashCode(Object var0);

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static void load(String pathName) {
        Runtime.getRuntime().load(pathName, VMStack.getCallingClassLoader());
    }

    public static void loadLibrary(String libName) {
        Runtime.getRuntime().loadLibrary(libName, VMStack.getCallingClassLoader());
    }

    public static void logE(String message) {
        System.log('E', message, null);
    }

    public static void logE(String message, Throwable th) {
        System.log('E', message, th);
    }

    public static void logI(String message) {
        System.log('I', message, null);
    }

    public static void logI(String message, Throwable th) {
        System.log('I', message, th);
    }

    public static void logW(String message) {
        System.log('W', message, null);
    }

    public static void logW(String message, Throwable th) {
        System.log('W', message, th);
    }

    private static native void log(char var0, String var1, Throwable var2);

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean flag) {
        Runtime.runFinalizersOnExit(flag);
    }

    public static void setProperties(Properties p) {
        systemProperties = p;
    }

    public static void setSecurityManager(SecurityManager sm) {
        if (sm != null) {
            throw new SecurityException();
        }
    }

    public static String mapLibraryName(String userLibName) {
        if (userLibName == null) {
            throw new NullPointerException("userLibName == null");
        }
        return System.mapLibraryName0(userLibName);
    }

    private static native String mapLibraryName0(String var0);

    private static native void setFieldImpl(String var0, String var1, Object var2);

    static {
        err = new PrintStream(new FileOutputStream(FileDescriptor.err));
        out = new PrintStream(new FileOutputStream(FileDescriptor.out));
        in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
        lineSeparator = System.getProperty("line.separator");
    }

    static class SystemEnvironment
    extends AbstractMap<String, String> {
        private final Map<String, String> map;

        public SystemEnvironment(Map<String, String> map) {
            this.map = Collections.unmodifiableMap(map);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public String get(Object key) {
            return this.map.get(this.toNonNullString(key));
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(this.toNonNullString(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(this.toNonNullString(value));
        }

        private String toNonNullString(Object o) {
            if (o == null) {
                throw new NullPointerException("o == null");
            }
            return (String)o;
        }
    }
}

