/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipFile;

class PathClassLoader
extends ClassLoader {
    private final String path;
    private final String libPath;
    private String[] mPaths;
    private File[] mFiles;
    private ZipFile[] mZips;
    private List<String> libraryPathElements;

    PathClassLoader(String path, ClassLoader parent, boolean nullAllowed) {
        this(path, null, parent, nullAllowed);
    }

    PathClassLoader(String path, String libPath, ClassLoader parent, boolean nullAllowed) {
        super(parent, nullAllowed);
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.libPath = libPath;
    }

    private synchronized void init() {
        String systemLibraryPath;
        if (this.mPaths != null) {
            return;
        }
        this.mPaths = this.path.split(System.getProperty("path.separator"));
        int length = this.mPaths.length;
        this.mFiles = new File[length];
        this.mZips = new ZipFile[length];
        for (int i = 0; i < length; ++i) {
            File pathFile;
            this.mFiles[i] = pathFile = new File(this.mPaths[i]);
            if (!pathFile.isFile()) continue;
            try {
                this.mZips[i] = new ZipFile(pathFile);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.libraryPathElements = new ArrayList<String>();
        if (this.libPath != null) {
            for (String pathElement : this.libPath.split(File.pathSeparator)) {
                this.libraryPathElements.add(this.cleanupPathElement(pathElement));
            }
        }
        if (!(systemLibraryPath = System.getProperty("java.library.path", ".")).isEmpty()) {
            for (String pathElement : systemLibraryPath.split(File.pathSeparator)) {
                this.libraryPathElements.add(this.cleanupPathElement(pathElement));
            }
        }
    }

    private String cleanupPathElement(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return VMClassLoader.findClassInClasspathForLoader(this, name);
    }

    @Override
    protected URL findResource(String name) {
        this.init();
        int length = this.mPaths.length;
        for (int i = 0; i < length; ++i) {
            URL result = this.findResource(name, i);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String resName) {
        this.init();
        int length = this.mPaths.length;
        ArrayList<URL> results = new ArrayList<URL>();
        for (int i = 0; i < length; ++i) {
            URL result = this.findResource(resName, i);
            if (result == null) continue;
            results.add(result);
        }
        return new EnumerateListArray<URL>(results);
    }

    private URL findResource(String name, int i) {
        File pathFile = this.mFiles[i];
        ZipFile zip2 = this.mZips[i];
        if (zip2 != null) {
            if (this.isInArchive(zip2, name)) {
                try {
                    return new URL("jar:" + pathFile.toURI() + "!/" + name);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (pathFile.isDirectory()) {
            File dataFile = new File(this.mPaths[i] + "/" + name);
            if (dataFile.exists()) {
                try {
                    return dataFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (!pathFile.isFile()) {
            System.err.println("PathClassLoader: can't find '" + this.mPaths[i] + "'");
        }
        return null;
    }

    private boolean isInArchive(ZipFile zip2, String name) {
        return zip2.getEntry(name) != null;
    }

    @Override
    public String findLibrary(String libname) {
        this.init();
        String fileName = System.mapLibraryName(libname);
        for (String pathElement : this.libraryPathElements) {
            String pathName = pathElement + fileName;
            File test = new File(pathName);
            if (!test.exists()) continue;
            return pathName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package getPackage(String name) {
        if (name != null && !name.isEmpty()) {
            PathClassLoader pathClassLoader = this;
            synchronized (pathClassLoader) {
                Package pack = super.getPackage(name);
                if (pack == null) {
                    pack = this.definePackage(name, "Unknown", "0.0", "Unknown", "Unknown", "0.0", "Unknown", null);
                }
                return pack;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.path + "]";
    }

    private static class EnumerateListArray<T>
    implements Enumeration<T> {
        private final ArrayList<T> mList;
        private int i = 0;

        EnumerateListArray(ArrayList<T> list) {
            this.mList = list;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.mList.size();
        }

        @Override
        public T nextElement() {
            if (this.i >= this.mList.size()) {
                throw new NoSuchElementException();
            }
            return this.mList.get(this.i++);
        }
    }
}

